/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.fhir;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.hl7.resource.ResourceReader;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.hl7.fhir.r4.model.Resource;

public class FHIRResourceMapper {
    private static FHIRResourceMapper fhirResourceMapper;
    private Map<String, String> resourceMapping;

    private FHIRResourceMapper() {
        String resource = ResourceReader.getInstance().getResource("fhir/resourcemapping.yml");
        try {
            this.resourceMapping = (Map)ObjectMapperUtil.getYAMLInstance().readValue(resource, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot read resource mapping file fhir/resourcemapping.yml ", e);
        }
    }

    public static Class<? extends Resource> getResourceClass(String name) {
        String resourceName;
        if (fhirResourceMapper == null) {
            fhirResourceMapper = new FHIRResourceMapper();
        }
        if ((resourceName = FHIRResourceMapper.fhirResourceMapper.resourceMapping.get(name)) != null) {
            try {
                return ClassUtils.getClass((String)resourceName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Resource type not mapped in FHIRResourceMapper , resource name: " + name, e);
            }
        }
        throw new IllegalStateException("Resource type not mapped in FHIRResourceMapper , resource name: " + name);
    }
}

