/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.core.Constants;
import org.hl7.fhir.r4.model.Bundle;

public class ConverterOptions {
    public static final ConverterOptions SIMPLE_OPTIONS = new Builder().build();
    private Bundle.BundleType bundleType;
    private boolean prettyPrint;
    private boolean validateResource;

    private ConverterOptions(Builder builder) {
        this.bundleType = builder.bundleType != null ? builder.bundleType : Constants.DEFAULT_BUNDLE_TYPE;
        this.prettyPrint = builder.prettyPrint;
        this.validateResource = builder.validateResource;
    }

    public Bundle.BundleType getBundleType() {
        return this.bundleType;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public boolean isValidateResource() {
        return this.validateResource;
    }

    public static class Builder {
        private Bundle.BundleType bundleType;
        private boolean prettyPrint;
        private boolean validateResource;

        public Builder withBundleType(Bundle.BundleType bundleType) {
            Preconditions.checkArgument((bundleType != null ? 1 : 0) != 0, (Object)"Bundle type cannot be null");
            this.bundleType = bundleType;
            return this;
        }

        public Builder withPrettyPrint() {
            this.prettyPrint = true;
            return this;
        }

        public Builder withValidateResource() {
            this.validateResource = true;
            return this;
        }

        public ConverterOptions build() {
            return new ConverterOptions(this);
        }
    }
}

