/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.data;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import io.github.linuxforhealth.hl7.data.Hl7DataHandlerUtil;
import io.github.linuxforhealth.hl7.data.date.DateUtil;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;
import org.hl7.fhir.r4.model.codesystems.EncounterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7RelatedGeneralUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hl7RelatedGeneralUtils.class);

    private Hl7RelatedGeneralUtils() {
    }

    public static String extractLow(Object var) {
        StringTokenizer stk;
        String val = Hl7DataHandlerUtil.getStringValue(var);
        if (StringUtils.isNotBlank((CharSequence)val) && (stk = new StringTokenizer(val, "-")).hasNext()) {
            return stk.next();
        }
        return null;
    }

    public static String extractHigh(Object var) {
        String[] values;
        String val = Hl7DataHandlerUtil.getStringValue(var);
        if (StringUtils.isNotBlank((CharSequence)val) && (values = val.split("-")).length == 2) {
            return values[1];
        }
        return null;
    }

    public static String getEncounterStatus(Object var1, Object var2, Object var3) {
        LOGGER.info("Generating encounter status from var1{}, var2 {}, var3 {}", new Object[]{var1, var2, var3});
        EncounterStatus status = EncounterStatus.UNKNOWN;
        if (var1 != null) {
            status = EncounterStatus.FINISHED;
        } else if (var2 != null) {
            status = EncounterStatus.ARRIVED;
        } else if (var3 != null) {
            status = EncounterStatus.CANCELLED;
        }
        return status.toCode();
    }

    public static String generateName(Object prefix, Object first, Object middle, Object family, Object suffix) {
        String name;
        LOGGER.info("Generating name from  from prefix {}, first {}, family {} ,suffix {}", new Object[]{prefix, first, middle, family, suffix});
        StringBuilder sb = new StringBuilder();
        String valprefix = Hl7DataHandlerUtil.getStringValue(prefix);
        String valfirst = Hl7DataHandlerUtil.getStringValue(first);
        String valmiddle = Hl7DataHandlerUtil.getStringValue(middle);
        String valfamily = Hl7DataHandlerUtil.getStringValue(family);
        String valsuffix = Hl7DataHandlerUtil.getStringValue(suffix);
        if (valprefix != null) {
            sb.append(valprefix).append(" ");
        }
        if (valfirst != null) {
            sb.append(valfirst).append(" ");
        }
        if (valmiddle != null) {
            sb.append(valmiddle).append(" ");
        }
        if (valfamily != null) {
            sb.append(valfamily).append(" ");
        }
        if (valsuffix != null) {
            sb.append(valsuffix).append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)(name = sb.toString()))) {
            return name.trim();
        }
        return null;
    }

    public static Long diffDateMin(Object start, Object end) {
        LOGGER.info("Generating time diff in min  from var1 {}, var2 {}", start, end);
        try {
            Temporal date1 = DateUtil.getTemporal(Hl7DataHandlerUtil.getStringValue(start));
            Temporal date2 = DateUtil.getTemporal(Hl7DataHandlerUtil.getStringValue(end));
            LOGGER.info("temporal dates start: {} , end: {} ", (Object)date1, (Object)date2);
            if (date1 != null && date2 != null) {
                return ChronoUnit.MINUTES.between(date1, date2);
            }
        }
        catch (UnsupportedTemporalTypeException e) {
            LOGGER.warn("Cannot evaluate time difference for start: {} , end: {} reason {} ", new Object[]{start, end, e.getMessage()});
            LOGGER.debug("Cannot evaluate time difference for start: {} , end: {} ", new Object[]{start, end, e});
            return null;
        }
        return null;
    }

    public static String split(Object input, String delimitter, int index) {
        StringTokenizer stk;
        String stringRepVal = Hl7DataHandlerUtil.getStringValue(input);
        if (StringUtils.isNotBlank((CharSequence)stringRepVal) && (stk = new StringTokenizer(stringRepVal, delimitter)).getTokenList().size() > index) {
            return (String)stk.getTokenList().get(index);
        }
        return null;
    }

    public static String concatenateWithChar(Object input, String delimiterChar) {
        String delimiter = delimiterChar;
        if (delimiterChar.equals("\\n")) {
            delimiter = Character.toString('\n');
        }
        return Hl7DataHandlerUtil.getStringValue(input, true, delimiter, false);
    }

    public static List<String> makeStringArray(String ... strs) {
        ArrayList<String> result = new ArrayList<String>();
        for (String str : strs) {
            if (str == null) continue;
            result.add(str);
        }
        return result;
    }

    public static String getAddressUse(String xad7Type, String xad16Temp, String xad17Bad) {
        LOGGER.info("Calculating address Use from XAD.7 {}, XAD.16 {}, XAD.17 {}", new Object[]{xad7Type, xad16Temp, xad17Bad});
        String addressUse = "";
        if (xad16Temp != null && xad16Temp.equalsIgnoreCase("Y") || (xad16Temp == null || xad16Temp.isEmpty()) && xad7Type != null && xad7Type.equalsIgnoreCase("C")) {
            addressUse = "temp";
        } else if (xad17Bad != null && xad17Bad.equalsIgnoreCase("Y") || (xad17Bad == null || xad17Bad.isEmpty()) && xad7Type != null && xad7Type.equalsIgnoreCase("BA")) {
            addressUse = "old";
        } else if (xad7Type != null && xad7Type.equalsIgnoreCase("H")) {
            addressUse = "home";
        } else if (xad7Type != null && (xad7Type.equalsIgnoreCase("B") || xad7Type.equalsIgnoreCase("O"))) {
            addressUse = "work";
        } else if (xad7Type != null && xad7Type.equalsIgnoreCase("BI")) {
            addressUse = "billing";
        }
        return addressUse;
    }

    public static String getAddressType(String xad7Type, String xad18Type) {
        LOGGER.info("Calculating address Type from XAD.7 {}, XAD.18 {}", (Object)xad7Type, (Object)xad18Type);
        String addressType = "";
        if (xad18Type != null && xad18Type.equalsIgnoreCase("M") || (xad18Type == null || xad18Type.isEmpty()) && xad7Type != null && xad7Type.equalsIgnoreCase("M")) {
            addressType = "postal";
        } else if (xad18Type != null && xad18Type.equalsIgnoreCase("V") || (xad18Type == null || xad18Type.isEmpty()) && xad7Type != null && xad7Type.equalsIgnoreCase("SH")) {
            addressType = "physical";
        }
        return addressType;
    }

    public static String getAddressDistrict(String patientCountyPid12, String addressCountyParishPid119, Object patient) {
        LOGGER.info("getAddressCountyParish for {}", patient);
        String returnDistrict = addressCountyParishPid119;
        if (returnDistrict == null) {
            Segment pidSegment = (Segment)patient;
            try {
                Type[] addresses = pidSegment.getField(11);
                if (addresses.length == 1) {
                    returnDistrict = patientCountyPid12;
                }
            }
            catch (HL7Exception hL7Exception) {
                // empty catch block
            }
        }
        return returnDistrict;
    }

    public static String getFormattedTelecomNumberValue(String xtn1Old, String xtn5Country, String xtn6Area, String xtn7Local, String xtn8Extension, String xtn12Unformatted) {
        String returnValue = "";
        if (xtn7Local != null && xtn7Local.length() > 0) {
            returnValue = Hl7RelatedGeneralUtils.formatCountryAndArea(xtn5Country, xtn6Area) + Hl7RelatedGeneralUtils.formatLocalNumber(xtn7Local);
            if (xtn8Extension != null && xtn8Extension.length() > 0) {
                returnValue = returnValue + " ext. " + xtn8Extension;
            }
        } else if (xtn12Unformatted != null && xtn12Unformatted.length() > 0) {
            returnValue = xtn12Unformatted;
        } else if (xtn1Old != null && xtn1Old.length() > 0) {
            returnValue = xtn1Old;
        }
        return returnValue;
    }

    private static String formatLocalNumber(String localNumber) {
        return localNumber.substring(0, 3) + " " + localNumber.substring(3);
    }

    private static String formatCountryAndArea(String country, String area) {
        String returnValue = "";
        if (area != null && area.length() > 0) {
            returnValue = country != null && country.length() > 0 ? "+" + country + " " + area + " " : "(" + area + ") ";
        }
        return returnValue;
    }
}

