/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.data;

import ca.uhn.hl7v2.model.v26.datatype.CWE;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.core.terminology.Hl7v2Mapping;
import io.github.linuxforhealth.core.terminology.SimpleCode;
import io.github.linuxforhealth.core.terminology.TerminologyLookup;
import io.github.linuxforhealth.core.terminology.UrlLookup;
import io.github.linuxforhealth.hl7.data.Hl7DataHandlerUtil;
import io.github.linuxforhealth.hl7.data.ValueExtractor;
import io.github.linuxforhealth.hl7.data.date.DateUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r4.model.codesystems.ConditionCategory;
import org.hl7.fhir.r4.model.codesystems.MessageReasonEncounter;
import org.hl7.fhir.r4.model.codesystems.NameUse;
import org.hl7.fhir.r4.model.codesystems.V3MaritalStatus;
import org.hl7.fhir.r4.model.codesystems.V3ReligiousAffiliation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDataValueResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDataValueResolver.class);
    public static final ValueExtractor<Object, String> DATE = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val != null) {
            return DateUtil.formatToDate(val);
        }
        return null;
    };
    public static final ValueExtractor<Object, String> DATE_TIME = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val != null) {
            return DateUtil.formatToDateTimeWithZone(val);
        }
        return null;
    };
    public static final ValueExtractor<Object, String> STRING = value -> Hl7DataHandlerUtil.getStringValue(value);
    public static final ValueExtractor<Object, String> STRING_ALL = value -> Hl7DataHandlerUtil.getStringValue(value, true);
    public static final ValueExtractor<Object, String> INSTANT = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val != null) {
            return DateUtil.formatToZonedDateTime(val);
        }
        return null;
    };
    public static final ValueExtractor<Object, URI> URI_VAL = value -> {
        try {
            String val = Hl7DataHandlerUtil.getStringValue(value);
            if (val != null && SimpleDataValueResolver.isValidUUID(val)) {
                return new URI("urn", "uuid", val);
            }
            return null;
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            LOGGER.warn("Value not valid URI, value: {}", value, (Object)e);
            return null;
        }
    };
    public static final ValueExtractor<Object, String> ADMINISTRATIVE_GENDER_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, Enumerations.AdministrativeGender.class);
        if (code != null) {
            return code;
        }
        if (val == null) {
            return null;
        }
        return Enumerations.AdministrativeGender.UNKNOWN.toCode();
    };
    public static final ValueExtractor<Object, String> MEDREQ_STATUS_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, MedicationRequest.class);
        if (code != null) {
            return code;
        }
        return "unknown";
    };
    public static final ValueExtractor<Object, String> OBSERVATION_STATUS_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, Observation.ObservationStatus.class);
        if (code != null) {
            return code;
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> OBSERVATION_STATUS_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, Observation.ObservationStatus.class);
        if (code != null) {
            Observation.ObservationStatus status = Observation.ObservationStatus.fromCode((String)code);
            return new SimpleCode(code, status.getSystem(), status.getDisplay());
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> CONDITION_CATEGORY_CODES = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val != null) {
            ConditionCategory status = ConditionCategory.fromCode((String)val);
            return new SimpleCode(val, status.getSystem(), status.getDisplay());
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> RELIGIOUS_AFFILIATION_FHIR_CC = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, V3ReligiousAffiliation.class);
        if (code != null) {
            V3ReligiousAffiliation status = V3ReligiousAffiliation.fromCode((String)code);
            return new SimpleCode(code, status.getSystem(), status.getDisplay());
        }
        return new SimpleCode(val, null, null);
    };
    public static final ValueExtractor<Object, String> IMMUNIZATION_STATUS_CODES = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, Immunization.ImmunizationStatus.class);
        if (code != null) {
            return code;
        }
        return null;
    };
    public static final ValueExtractor<Object, String> SPECIMEN_STATUS_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, Specimen.SpecimenStatus.class);
        if (code != null) {
            return code;
        }
        return null;
    };
    public static final ValueExtractor<Object, String> NAME_USE_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, NameUse.class);
        if (code != null) {
            return code;
        }
        return null;
    };
    public static final ValueExtractor<Object, Object> MARITAL_STATUS = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, V3MaritalStatus.class);
        if (code != null) {
            V3MaritalStatus mar = V3MaritalStatus.fromCode((String)code);
            return new SimpleCode(code, mar.getSystem(), mar.getDisplay());
        }
        return null;
    };
    public static final ValueExtractor<Object, Boolean> BOOLEAN = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (null == val) {
            return false;
        }
        return BooleanUtils.toBoolean((String)val);
    };
    public static final ValueExtractor<Object, Integer> INTEGER = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (null == val) {
            return null;
        }
        if (NumberUtils.isCreatable((String)val)) {
            return NumberUtils.createInteger((String)val);
        }
        LOGGER.warn("Value {} for INTEGER is not a valid number so returning null.", value);
        return null;
    };
    public static final ValueExtractor<Object, Float> FLOAT = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (null == val) {
            return null;
        }
        if (NumberUtils.isCreatable((String)val)) {
            return NumberUtils.createFloat((String)val);
        }
        LOGGER.warn("Value {} for DECIMAL is not a valid number so returning null.", value);
        return null;
    };
    public static final ValueExtractor<Object, UUID> UUID_VAL = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getUUID(val);
    };
    public static final ValueExtractor<Object, String> BASE64_BINARY = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return Base64.getEncoder().encodeToString(val.getBytes());
    };
    public static final ValueExtractor<Object, Object> OBJECT = value -> value;
    public static final ValueExtractor<Object, SimpleCode> CODING_SYSTEM_V2_ALTERNATE = value -> {
        if (value instanceof CWE) {
            CWE cwe = (CWE)value;
            String table = Hl7DataHandlerUtil.getStringValue(cwe.getCwe6_NameOfAlternateCodingSystem());
            String code = Hl7DataHandlerUtil.getStringValue(cwe.getCwe4_AlternateIdentifier());
            String text = Hl7DataHandlerUtil.getStringValue(cwe.getCwe5_AlternateText());
            String version = Hl7DataHandlerUtil.getStringValue(cwe.getCwe8_AlternateCodingSystemVersionID());
            return SimpleDataValueResolver.commonCodingSystemV2(table, code, text, version);
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> CODING_SYSTEM_V2 = value -> {
        String table = Hl7DataHandlerUtil.getTableNumber(value);
        String code = Hl7DataHandlerUtil.getStringValue(value);
        String text = Hl7DataHandlerUtil.getOriginalDisplayText(value);
        String version = Hl7DataHandlerUtil.getVersion(value);
        return SimpleDataValueResolver.commonCodingSystemV2(table, code, text, version);
    };
    public static final ValueExtractor<Object, String> BUILD_IDENTIFIER_FROM_CWE = value -> {
        CWE newValue = (CWE)value;
        String identifier = newValue.getCwe1_Identifier().toString();
        String text = newValue.getCwe2_Text().toString();
        String codingSystem = newValue.getCwe3_NameOfCodingSystem().toString();
        if (identifier != null) {
            if (codingSystem != null) {
                String join = identifier + "-" + codingSystem;
                return join;
            }
            return identifier;
        }
        return text;
    };
    public static final ValueExtractor<Object, String> ALLERGY_INTOLERANCE_CRITICALITY_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, AllergyIntolerance.AllergyIntoleranceCriticality.class);
        if (code != null) {
            return code;
        }
        return null;
    };
    public static final ValueExtractor<Object, String> ALLERGY_INTOLERANCE_CATEGORY_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, AllergyIntolerance.AllergyIntoleranceCategory.class);
        if (code != null) {
            return code;
        }
        return null;
    };
    public static final ValueExtractor<Object, String> SYSTEM_URL = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return UrlLookup.getAssociatedUrl(val);
    };
    public static final ValueExtractor<Object, String> SYSTEM_ID = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val != null && val.length() > 0) {
            return "urn:id:" + val.replace(" ", "_");
        }
        return null;
    };
    public static final ValueExtractor<Object, List<?>> ARRAY = value -> {
        if (value != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            return list;
        }
        return null;
    };
    public static final ValueExtractor<Object, String> RELATIVE_REFERENCE = value -> {
        Map<String, Object> mapValue = null;
        if (value instanceof Map) {
            mapValue = (Map<String, Object>)value;
        } else if (value instanceof ResourceValue) {
            ResourceValue rv = (ResourceValue)value;
            mapValue = rv.getResource();
        }
        if (mapValue != null) {
            String type = Hl7DataHandlerUtil.getStringValue(mapValue.get("resourceType"));
            String refId = Hl7DataHandlerUtil.getStringValue(mapValue.get("id"));
            if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)refId)) {
                return type + "/" + refId;
            }
        }
        return null;
    };
    public static final ValueExtractor<Object, String> DIAGNOSTIC_REPORT_STATUS_CODES = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, DiagnosticReport.DiagnosticReportStatus.class);
        if (code != null) {
            return code;
        }
        return DiagnosticReport.DiagnosticReportStatus.UNKNOWN.toCode();
    };
    public static final ValueExtractor<Object, UUID> NAMED_UUID = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return UUID.nameUUIDFromBytes(val.getBytes());
        }
        return null;
    };
    public static final ValueExtractor<Object, Object> MESSAGE_REASON_ENCOUNTER = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, MessageReasonEncounter.class);
        if (code != null) {
            MessageReasonEncounter en = MessageReasonEncounter.fromCode((String)code);
            return new SimpleCode(code, en.getSystem(), en.getDisplay());
        }
        return null;
    };

    private static final SimpleCode commonCodingSystemV2(String table, String code, String text, String version) {
        if (table != null && code != null) {
            SimpleCode coding = TerminologyLookup.lookup(table, code);
            if (coding != null) {
                String display = coding.getDisplay();
                if (display != null) {
                    if (display.isEmpty()) {
                        coding = new SimpleCode(coding.getCode(), coding.getSystem(), text, version);
                    }
                    coding.setVersion(version);
                    return coding;
                }
                display = "Invalid input: code: '" + code + "' for system: '" + table + "' original display: '" + text + "'";
                return new SimpleCode(null, coding.getSystem(), display);
            }
            return new SimpleCode(code, "urn:id:" + table, text, version);
        }
        if (code != null) {
            return new SimpleCode(code, null, null);
        }
        return null;
    }

    private SimpleDataValueResolver() {
    }

    private static UUID getUUID(String value) {
        if (value != null) {
            try {
                return UUID.fromString(value);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Value not valid UUID, value: {}  failure reason {}", (Object)value, (Object)e.getMessage());
                LOGGER.debug("Value not valid UUID, value: {}", (Object)value, (Object)e);
                return null;
            }
        }
        LOGGER.info("Value for  UUID is null, value: {}", (Object)value);
        return null;
    }

    private static boolean isValidUUID(String val) {
        try {
            UUID.fromString(val);
            return true;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Not a valid UUID reason {} ", (Object)e.getMessage());
            LOGGER.debug("Not a valid UUID ", (Throwable)e);
            return false;
        }
    }

    private static String getFHIRCode(String hl7Value, Class<?> fhirConceptClassName) {
        if (hl7Value != null) {
            Map<String, String> mapping = Hl7v2Mapping.getMapping(fhirConceptClassName.getSimpleName());
            if (mapping != null && !mapping.isEmpty()) {
                return mapping.get(StringUtils.upperCase((String)hl7Value, (Locale)Locale.ENGLISH));
            }
            return null;
        }
        return null;
    }
}

