/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.data.date;

import io.github.linuxforhealth.core.config.ConverterConfiguration;
import io.github.linuxforhealth.hl7.data.date.DateFormats;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);

    private DateUtil() {
    }

    public static String formatToDate(String input) {
        DateTimeFormatter format = null;
        for (Map.Entry<Pattern, DateTimeFormatter> pattern : DateFormats.getDatePatternsInstance().entrySet()) {
            if (!pattern.getKey().matcher(input).matches()) continue;
            format = pattern.getValue();
            break;
        }
        try {
            LocalDate ldt = LocalDate.parse(input, DateFormats.getFormatterInstance());
            return ldt.format(format);
        }
        catch (DateTimeParseException e) {
            LOGGER.warn("Input value cannot be formatted to LocalDate {}", (Object)input, (Object)e);
            return null;
        }
    }

    public static String formatToDateTimeWithZone(String input) {
        String returnValue = DateUtil.getLocalDate(input);
        if (returnValue == null) {
            returnValue = DateUtil.getZonedDate(input);
        }
        if (returnValue == null) {
            returnValue = DateUtil.getLocalDateTimeWithDefaultZone(input);
        }
        return returnValue;
    }

    private static String getLocalDateTimeWithDefaultZone(String input) {
        try {
            LocalDateTime ldt = LocalDateTime.parse(input, DateFormats.getFormatterInstance());
            ZoneId zone = ConverterConfiguration.getInstance().getZoneId();
            if (zone != null) {
                String returnValue = ldt.atZone(zone).format(DateFormats.FHIR_ZONE_DATE_TIME_FORMAT);
                return returnValue;
            }
            LOGGER.warn("No default zone set, cannot convert LocalDateTime to ZonedDateTime, input {} ", (Object)input);
            return null;
        }
        catch (DateTimeParseException e) {
            LOGGER.warn("Date parsing failure for value '{}'   reason {}", (Object)input, (Object)e.getMessage());
            LOGGER.debug("Date parsing exception for value {}", (Object)input, (Object)e);
            return null;
        }
    }

    private static String getLocalDateTime(String input) {
        DateTimeFormatter format = null;
        for (Map.Entry<Pattern, DateTimeFormatter> pattern : DateFormats.getDateTimePatternsInstance().entrySet()) {
            if (!pattern.getKey().matcher(input).matches()) continue;
            format = pattern.getValue();
            break;
        }
        try {
            LocalDateTime ldt = LocalDateTime.parse(input, DateFormats.getFormatterInstance());
            String returnValue = ldt.format(format);
            return returnValue;
        }
        catch (DateTimeParseException e) {
            LOGGER.warn("Input value cannot be formatted to LocalDateTime '{}'   reason {}", (Object)input, (Object)e.getMessage());
            LOGGER.debug("Input value cannot be formatted to LocalDateTime {}", (Object)input, (Object)e);
            return null;
        }
    }

    private static String getLocalDate(String input) {
        DateTimeFormatter format = null;
        for (Map.Entry<Pattern, DateTimeFormatter> pattern : DateFormats.getDatePatternsWithoutTimeInstance().entrySet()) {
            if (!pattern.getKey().matcher(input).matches()) continue;
            format = pattern.getValue();
            break;
        }
        if (format != null) {
            try {
                LocalDate ldt = LocalDate.parse(input, DateFormats.getFormatterInstance());
                return ldt.atStartOfDay().format(format);
            }
            catch (DateTimeParseException e) {
                LOGGER.warn("Input value cannot be formatted to LocalDate {} reason: {}", (Object)input, (Object)e.getMessage());
                LOGGER.debug("Input value cannot be formatted to LocalDate {} ", (Object)input, (Object)e);
                return null;
            }
        }
        return null;
    }

    private static String getZonedDate(String input) {
        DateTimeFormatter format = null;
        for (Map.Entry<Pattern, DateTimeFormatter> pattern : DateFormats.getDatePatternsWithZoneInstance().entrySet()) {
            if (!pattern.getKey().matcher(input).matches()) continue;
            format = pattern.getValue();
            break;
        }
        if (format != null) {
            try {
                ZonedDateTime zdt = ZonedDateTime.parse(input, DateFormats.getFormatterInstance());
                return zdt.format(format);
            }
            catch (DateTimeParseException e) {
                LOGGER.warn("Input value cannot be parsed to ZonedDateTime {} reason: {}", (Object)input, (Object)e.getMessage());
                LOGGER.debug("Input value cannot be parsed to ZonedDateTime {} ", (Object)input, (Object)e);
                return null;
            }
        }
        return null;
    }

    public static Temporal getTemporal(String dateString) {
        HashMap<String, DateTimeParseException> warnings = new HashMap<String, DateTimeParseException>();
        if (dateString == null) {
            return null;
        }
        Comparable<Instant> temporal = null;
        try {
            temporal = Instant.parse(dateString);
            LOGGER.info("Date parsed for instant {}", (Object)dateString);
        }
        catch (DateTimeParseException e) {
            warnings.put("Input value cannot be parsed to  instant " + dateString, e);
        }
        if (temporal == null) {
            try {
                temporal = ZonedDateTime.parse(dateString, DateTimeFormatter.ISO_ZONED_DATE_TIME);
                LOGGER.info("Date parsed for ZonedDateTime {}", (Object)dateString);
            }
            catch (DateTimeParseException e) {
                warnings.put("Input value cannot be parsed to ZonedDateTime " + dateString, e);
            }
        }
        if (temporal == null) {
            try {
                temporal = LocalDateTime.parse(dateString, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                LOGGER.info("Date parsed for LocalDateTime {}", (Object)dateString);
            }
            catch (DateTimeParseException e) {
                warnings.put("Input value cannot be parsed to LocalDateTime " + dateString, e);
            }
        }
        if (temporal == null) {
            try {
                temporal = LocalDate.parse(dateString, DateTimeFormatter.ISO_LOCAL_DATE);
                LOGGER.info("Date parsed for LocalDate {}", (Object)dateString);
            }
            catch (DateTimeParseException e) {
                warnings.put("Input value cannot be parsed to LocalDate " + dateString, e);
            }
        }
        if (temporal == null && !warnings.isEmpty()) {
            LOGGER.warn("Attempt to parse input value {} to temporal failed ", (Object)dateString);
            for (Map.Entry entry : warnings.entrySet()) {
                LOGGER.warn("{} reason {}", entry.getKey(), (Object)((DateTimeParseException)entry.getValue()).getMessage());
                LOGGER.debug("{} reason {}", entry.getKey(), (Object)((DateTimeParseException)entry.getValue()).toString());
            }
        }
        return temporal;
    }

    public static String formatToZonedDateTime(String input) {
        String zoned = DateUtil.getZonedDate(input);
        if (zoned == null) {
            zoned = DateUtil.formatToDateTimeWithZone(input);
        }
        return zoned;
    }
}

