/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression.specification;

import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.Specification;
import io.github.linuxforhealth.hl7.message.HL7MessageData;
import java.util.Map;

public class HL7Specification
implements Specification {
    private String segment;
    private String field;
    private int component;
    private int subComponent;
    private boolean isExtractMultiple;
    private boolean retainEmpty;
    private String stringRep;
    private Class<? extends InputDataExtractor> sourceInputDataClass = HL7MessageData.class;

    public HL7Specification(String segment, String field, int component, int subComponent, boolean isMultiple, boolean retainEmpty) {
        this.segment = segment;
        this.field = field;
        this.component = component;
        this.subComponent = subComponent;
        this.isExtractMultiple = isMultiple;
        this.retainEmpty = retainEmpty;
        this.stringRep = this.getToStringRep();
    }

    public HL7Specification(String segment, String field, int component, int subComponent, boolean isMultiple) {
        this(segment, field, component, subComponent, false, false);
    }

    public HL7Specification(String segment, String field, int component, int subComponent) {
        this(segment, field, component, subComponent, false, false);
    }

    public String getSegment() {
        return this.segment;
    }

    public String getField() {
        return this.field;
    }

    public int getComponent() {
        return this.component;
    }

    public int getSubComponent() {
        return this.subComponent;
    }

    public String toString() {
        return this.stringRep;
    }

    private String getToStringRep() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.segment != null) {
            sb.append(this.segment);
        }
        if (this.field != null) {
            sb.append(".").append(this.field);
        }
        if (this.component > -1) {
            sb.append(".").append(this.component);
        }
        if (this.subComponent > -1) {
            sb.append(".").append(this.subComponent);
        }
        return sb.append("]").toString();
    }

    public boolean isExtractMultiple() {
        return this.isExtractMultiple;
    }

    public boolean getRetainEmptyFields() {
        return this.retainEmpty;
    }

    public Class<? extends InputDataExtractor> getSourceInputDataClass() {
        return this.sourceInputDataClass;
    }

    @Override
    public EvaluationResult extractValueForSpec(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues) {
        if (this.isExtractMultiple()) {
            return dataSource.extractMultipleValuesForSpec(this, contextValues);
        }
        return dataSource.extractValueForSpec(this, contextValues);
    }

    @Override
    public EvaluationResult extractMultipleValuesForSpec(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues) {
        return dataSource.extractMultipleValuesForSpec(this, contextValues);
    }
}

