/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression.specification;

import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.Specification;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.hl7.expression.specification.ContextMapData;
import java.util.HashMap;
import java.util.Map;

public class SimpleSpecification
implements Specification {
    private String variableName;
    private boolean isExtractMultiple;
    private boolean useGroup;
    private InputDataExtractor primaryDataSource = new ContextMapData();

    public SimpleSpecification(String variableName, boolean isMultiple, boolean useGroup) {
        this.variableName = variableName;
        this.isExtractMultiple = isMultiple;
        this.useGroup = useGroup;
    }

    public boolean isExtractMultiple() {
        return this.isExtractMultiple;
    }

    public String getVariable() {
        return this.variableName;
    }

    @Override
    public EvaluationResult extractValueForSpec(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues) {
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
        localContextValues.put("useGroup", EvaluationResultFactory.getEvaluationResult(this.useGroup));
        return this.primaryDataSource.extractValueForSpec(this, localContextValues);
    }

    @Override
    public EvaluationResult extractMultipleValuesForSpec(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues) {
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
        localContextValues.put("useGroup", EvaluationResultFactory.getEvaluationResult(this.useGroup));
        return this.primaryDataSource.extractMultipleValuesForSpec(this, localContextValues);
    }

    public boolean isUseGroup() {
        return this.useGroup;
    }

    public void setUseGroup(boolean useGroup) {
        this.useGroup = useGroup;
    }
}

