/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression.variable;

import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.hl7.data.SimpleDataTypeMapper;
import io.github.linuxforhealth.hl7.data.ValueExtractor;
import io.github.linuxforhealth.hl7.expression.variable.SimpleVariable;
import java.util.List;
import java.util.Map;

public class DataTypeVariable
extends SimpleVariable {
    private String valueType;
    private ValueExtractor<Object, ?> resolver;

    public DataTypeVariable(String name, String valueType, List<String> spec, boolean extractMultiple) {
        super(name, spec, extractMultiple, false);
        this.valueType = valueType;
        this.resolver = SimpleDataTypeMapper.getValueResolver(this.valueType);
    }

    @Override
    public EvaluationResult extractVariableValue(Map<String, EvaluationResult> contextValues, InputDataExtractor dataSource) {
        EvaluationResult result = !this.getSpec().isEmpty() ? this.getValueFromSpecs(contextValues, dataSource) : null;
        EvaluationResult resolvedvalue = null;
        resolvedvalue = result != null && this.resolver != null ? EvaluationResultFactory.getEvaluationResult(this.resolver.apply(result.getValue())) : result;
        return resolvedvalue;
    }

    public String getValueType() {
        return this.valueType;
    }

    public ValueExtractor<Object, ?> getResolver() {
        return this.resolver;
    }
}

