/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression.variable;

import com.google.common.collect.ImmutableMap;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.Specification;
import io.github.linuxforhealth.api.Variable;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.core.expression.VariableUtils;
import io.github.linuxforhealth.hl7.data.SimpleDataTypeMapper;
import io.github.linuxforhealth.hl7.expression.specification.SpecificationParser;
import io.github.linuxforhealth.hl7.util.ExpressionUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class SimpleVariable
implements Variable {
    public static final String OBJECT_TYPE = Object.class.getSimpleName();
    private String name;
    private List<String> spec;
    private boolean extractMultiple;
    private boolean combineMultiple;
    private boolean retainEmpty;

    public SimpleVariable(String name, List<String> spec) {
        this(name, spec, false, false, false);
    }

    public SimpleVariable(String name, List<String> spec, boolean extractMultiple, boolean combineMultiple) {
        this(name, spec, extractMultiple, combineMultiple, false);
    }

    public SimpleVariable(String name, List<String> spec, boolean extractMultiple, boolean combineMultiple, boolean retainEmpty) {
        this.name = name;
        this.spec = new ArrayList<String>();
        if (spec != null && !spec.isEmpty()) {
            this.spec.addAll(spec);
        }
        this.extractMultiple = extractMultiple;
        this.combineMultiple = combineMultiple;
        this.retainEmpty = retainEmpty;
    }

    @Override
    public List<String> getSpec() {
        return new ArrayList<String>(this.spec);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public EvaluationResult extractVariableValue(Map<String, EvaluationResult> contextValues, InputDataExtractor dataSource) {
        List<EvaluationResult> values;
        EvaluationResult result = !this.spec.isEmpty() ? ((values = this.getValuesFromSpecs(contextValues, dataSource, this.combineMultiple)).isEmpty() ? null : (values.size() == 1 ? values.get(0) : SimpleVariable.generateCombinedValue(values))) : null;
        return result;
    }

    private static EvaluationResult generateCombinedValue(List<EvaluationResult> values) {
        StringBuilder sb = new StringBuilder();
        for (EvaluationResult value : values) {
            if (value.getValue() == null) continue;
            sb.append(SimpleDataTypeMapper.getValueResolver("STRING").apply(value.getValue()));
        }
        return EvaluationResultFactory.getEvaluationResult(sb.toString());
    }

    protected EvaluationResult getValueFromSpecs(Map<String, EvaluationResult> contextValues, InputDataExtractor dataSource) {
        List<EvaluationResult> values = this.getValuesFromSpecs(contextValues, dataSource, false);
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    protected List<EvaluationResult> getValuesFromSpecs(Map<String, EvaluationResult> contextValues, InputDataExtractor dataSource, boolean fetchAll) {
        ArrayList<EvaluationResult> combineValue = new ArrayList<EvaluationResult>();
        for (String specValue : this.spec) {
            EvaluationResult fetchedValue = null;
            if (VariableUtils.isVar(specValue)) {
                fetchedValue = SimpleVariable.getVariableValueFromVariableContextMap(specValue, (ImmutableMap<String, EvaluationResult>)ImmutableMap.copyOf(contextValues));
            } else {
                Specification spec = SpecificationParser.parse(specValue, this.extractMultiple, false, this.retainEmpty);
                EvaluationResult gen = spec.extractValueForSpec(dataSource, contextValues);
                if (gen != null && !gen.isEmpty()) {
                    fetchedValue = gen;
                }
            }
            if (fetchedValue == null) continue;
            combineValue.add(fetchedValue);
            if (fetchAll) continue;
            return combineValue;
        }
        return combineValue;
    }

    private static EvaluationResult getVariableValueFromVariableContextMap(String varName, ImmutableMap<String, EvaluationResult> contextValues) {
        if (StringUtils.isNotBlank((CharSequence)varName)) {
            if (varName.startsWith("$") && varName.contains(":")) {
                return SimpleVariable.fetchValueFromVar(varName, contextValues);
            }
            EvaluationResult fetchedValue = (EvaluationResult)contextValues.get((Object)VariableUtils.getVarName(varName));
            return fetchedValue;
        }
        return null;
    }

    private static EvaluationResult fetchValueFromVar(String varName, ImmutableMap<String, EvaluationResult> contextValues) {
        String[] tokens = StringUtils.split((String)varName, (String)":", (int)2);
        ImmutablePair fetch = ImmutablePair.of((Object)tokens[0], (Object)tokens[1]);
        EvaluationResult resource = (EvaluationResult)contextValues.get((Object)VariableUtils.getVarName((String)fetch.left));
        return ExpressionUtility.extractComponent((ImmutablePair<String, String>)fetch, resource);
    }

    @Override
    public String getVariableName() {
        return VariableUtils.getVarName(this.name);
    }

    public boolean extractMultiple() {
        return this.extractMultiple;
    }

    public boolean retainEmpty() {
        return this.retainEmpty;
    }
}

