/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression.variable;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.Variable;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import io.github.linuxforhealth.hl7.expression.variable.DataTypeVariable;
import io.github.linuxforhealth.hl7.expression.variable.ExpressionVariable;
import io.github.linuxforhealth.hl7.expression.variable.SimpleVariable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcherFactory;

public class VariableGenerator {
    private static final int COMPONENT_LENGTH_FOR_VAR_EXPRESSION = 2;

    private VariableGenerator() {
    }

    public static Variable parse(String varName, String variableExpression) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)varName), (Object)"varName string cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)variableExpression), (Object)"rawVariable string cannot be null");
        ExpressionAttributes.ExpressionModifiers exp = ExpressionAttributes.extractExpressionModifiers(variableExpression);
        String rawVariable = exp.expression;
        if (StringUtils.contains((CharSequence)rawVariable, (CharSequence)"GeneralUtils")) {
            String[] values = rawVariable.split(",", 2);
            exp = ExpressionAttributes.extractExpressionModifiers(values[0]);
            if (values.length == 2) {
                List<String> specs = VariableGenerator.getTokens(exp.expression);
                return new ExpressionVariable(varName, values[1], specs, exp.extractMultiple, exp.retainEmpty);
            }
            throw new IllegalArgumentException("rawVariable not in correct format ");
        }
        if (StringUtils.contains((CharSequence)rawVariable, (CharSequence)",")) {
            String[] values = rawVariable.split(",", 2);
            if (values.length == 2) {
                List<String> specs = VariableGenerator.getTokens(values[1]);
                return new DataTypeVariable(varName, values[0], specs, exp.extractMultiple);
            }
            throw new IllegalArgumentException("rawVariable not in correct format ");
        }
        boolean combineValues = false;
        if (StringUtils.contains((CharSequence)rawVariable, (CharSequence)"+")) {
            combineValues = true;
        }
        List<String> specs = VariableGenerator.getTokens(rawVariable);
        return new SimpleVariable(varName, specs, exp.extractMultiple, combineValues, exp.retainEmpty);
    }

    private static List<String> getTokens(String value) {
        if (StringUtils.contains((CharSequence)value, (CharSequence)"+")) {
            StringTokenizer st = new StringTokenizer(value, "+").setIgnoreEmptyTokens(true).setTrimmerMatcher(StringMatcherFactory.INSTANCE.spaceMatcher());
            return st.getTokenList();
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            StringTokenizer st = new StringTokenizer(value, "|").setIgnoreEmptyTokens(true).setTrimmerMatcher(StringMatcherFactory.INSTANCE.spaceMatcher());
            return st.getTokenList();
        }
        return new ArrayList<String>();
    }
}

