/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.message;

import ca.uhn.hl7v2.model.Structure;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.FHIRResourceTemplate;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.MessageEngine;
import io.github.linuxforhealth.api.ResourceModel;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.core.Constants;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.core.exception.RequiredConstraintFailureException;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.core.resource.ResourceResult;
import io.github.linuxforhealth.fhir.FHIRContext;
import io.github.linuxforhealth.fhir.FHIRResourceMapper;
import io.github.linuxforhealth.hl7.message.HL7FHIRResourceTemplate;
import io.github.linuxforhealth.hl7.message.HL7MessageData;
import io.github.linuxforhealth.hl7.message.util.SegmentExtractorUtil;
import io.github.linuxforhealth.hl7.message.util.SegmentGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Resource;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class HL7MessageEngine
implements MessageEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(HL7MessageEngine.class);
    private static final ObjectMapper OBJ_MAPPER = ObjectMapperUtil.getJSONInstance();
    private FHIRContext context;
    private Bundle.BundleType bundleType;

    public HL7MessageEngine(FHIRContext context) {
        this(context, Constants.DEFAULT_BUNDLE_TYPE);
    }

    public HL7MessageEngine(FHIRContext context, Bundle.BundleType bundleType) {
        this.context = context;
        this.bundleType = bundleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle transform(InputDataExtractor dataInput, Iterable<FHIRResourceTemplate> resources, Map<String, EvaluationResult> contextValues) {
        Preconditions.checkArgument((dataInput != null ? 1 : 0) != 0, (Object)"dataInput cannot be null");
        Preconditions.checkArgument((contextValues != null ? 1 : 0) != 0, (Object)"contextValues cannot be null");
        Preconditions.checkArgument((resources != null ? 1 : 0) != 0, (Object)"resources cannot be null");
        HL7MessageData hl7DataInput = (HL7MessageData)dataInput;
        Bundle bundle = this.initBundle();
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
        for (FHIRResourceTemplate genericTemplate : resources) {
            HL7FHIRResourceTemplate hl7ResourceTemplate = (HL7FHIRResourceTemplate)genericTemplate;
            ResourceModel rs = genericTemplate.getResource();
            ArrayList<ResourceResult> resourceResults = new ArrayList<ResourceResult>();
            try {
                MDC.put((String)"Resource", (String)rs.getName());
                List<ResourceResult> results = this.generateResources(hl7DataInput, hl7ResourceTemplate, localContextValues, bundle);
                if (results != null) {
                    resourceResults.addAll(results);
                }
                resourceResults.removeIf(HL7MessageEngine.isEmpty());
                Map<String, EvaluationResult> newContextValues = HL7MessageEngine.getContextValuesFromResource(hl7ResourceTemplate, resourceResults);
                localContextValues.putAll(newContextValues);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                LOGGER.error("Exception during  resource {} generation", (Object)rs.getName(), (Object)e);
            }
            finally {
                MDC.remove((String)"Resource");
            }
        }
        LOGGER.info("Successfully converted Message: {} , Message Control Id: {} to FHIR bundle resource with id {}", new Object[]{dataInput.getName(), dataInput.getId(), bundle.getId()});
        return bundle;
    }

    private List<ResourceResult> generateResources(HL7MessageData hl7DataInput, HL7FHIRResourceTemplate template, Map<String, EvaluationResult> contextValues, Bundle bundle) {
        ResourceModel resourceModel = template.getResource();
        List<String> segmentGroup = template.getAttributes().getSegment().getGroup();
        String segment = template.getAttributes().getSegment().getSegment();
        List<ResourceResult> resourceResults = null;
        List<SegmentGroup> multipleSegments = HL7MessageEngine.getMultipleSegments(hl7DataInput, template, segmentGroup, segment);
        if (!multipleSegments.isEmpty()) {
            resourceResults = HL7MessageEngine.generateMultipleResources(hl7DataInput, resourceModel, contextValues, multipleSegments, template.isGenerateMultiple());
        }
        if (resourceResults != null && !resourceResults.isEmpty()) {
            for (ResourceResult resReult : resourceResults) {
                this.addToBundle(bundle, Lists.newArrayList((Object[])new ResourceValue[]{resReult.getValue()}));
                this.addToBundle(bundle, resReult.getAdditionalResources());
            }
        }
        return resourceResults;
    }

    private static Predicate<ResourceResult> isEmpty() {
        return p -> p == null || p.isEmpty() || p.getValue().isEmpty();
    }

    private static Map<String, EvaluationResult> getContextValuesFromResource(FHIRResourceTemplate resTemplate, List<ResourceResult> resourceResults) {
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>();
        if (resourceResults.isEmpty() || !resTemplate.isReferenced()) {
            return localContextValues;
        }
        if (!resTemplate.isGenerateMultiple()) {
            localContextValues.put(resTemplate.getResourceName(), EvaluationResultFactory.getEvaluationResult(resourceResults.get(0).getValue().getResource()));
        } else {
            Map<String, List<ResourceResult>> resourcesByGroup = resourceResults.stream().collect(Collectors.groupingBy(r -> HL7MessageEngine.getResultIdentifier(resTemplate, r)));
            for (Map.Entry<String, List<ResourceResult>> e : resourcesByGroup.entrySet()) {
                ArrayList evl = new ArrayList();
                e.getValue().forEach(res -> evl.add(res.getValue()));
                localContextValues.put(e.getKey(), EvaluationResultFactory.getEvaluationResult(evl));
            }
        }
        return localContextValues;
    }

    private static String getResultIdentifier(FHIRResourceTemplate resTemplate, ResourceResult result) {
        if (result != null && result.getGroupId() != null) {
            return resTemplate.getResourceName() + "_" + result.getGroupId();
        }
        return resTemplate.getResourceName();
    }

    private Bundle initBundle() {
        Bundle bundle = new Bundle();
        bundle.setType(this.bundleType);
        bundle.setId(UUID.randomUUID().toString());
        Meta m = new Meta();
        m.setLastUpdated(LocalDateTime.now().toDate());
        bundle.setMeta(m);
        return bundle;
    }

    private static Map<String, EvaluationResult> getContextMap(SegmentGroup segmentGroup) {
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>();
        if (!segmentGroup.getAdditionalSegments().isEmpty()) {
            for (Map.Entry<String, List<Structure>> e : segmentGroup.getAdditionalSegments().entrySet()) {
                localContextValues.put(e.getKey(), EvaluationResultFactory.getEvaluationResult(e.getValue()));
            }
        }
        return localContextValues;
    }

    private static List<SegmentGroup> getMultipleSegments(HL7MessageData hl7DataInput, HL7FHIRResourceTemplate template, List<String> segmentGroup, String segment) {
        List<SegmentGroup> multipleSegments = segmentGroup != null && !segmentGroup.isEmpty() ? SegmentExtractorUtil.extractSegmentGroups(segmentGroup, segment, template.getAttributes().getAdditionalSegments(), hl7DataInput.getHL7DataParser(), template.getAttributes().getGroup()) : SegmentExtractorUtil.extractSegmentNonGroups(segment, template.getAttributes().getAdditionalSegments(), hl7DataInput.getHL7DataParser());
        return multipleSegments;
    }

    private static List<ResourceResult> generateMultipleResources(HL7MessageData hl7DataInput, ResourceModel rs, Map<String, EvaluationResult> contextValues, List<SegmentGroup> multipleSegments, boolean generateMultiple) {
        ArrayList<ResourceResult> resourceResults = new ArrayList<ResourceResult>();
        for (SegmentGroup currentGroup : multipleSegments) {
            HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
            localContextValues.put("GROUP_ID", EvaluationResultFactory.getEvaluationResult(currentGroup.getGroupId()));
            ArrayList baseValues = new ArrayList();
            currentGroup.getSegments().forEach(struct -> baseValues.add(EvaluationResultFactory.getEvaluationResult(struct)));
            localContextValues.putAll(HL7MessageEngine.getContextMap(currentGroup));
            for (EvaluationResult baseValue : baseValues) {
                try {
                    ResourceResult result = rs.evaluate(hl7DataInput, (Map<String, EvaluationResult>)ImmutableMap.copyOf(localContextValues), baseValue);
                    if (result == null || result.getValue() == null) continue;
                    resourceResults.add(result);
                    if (generateMultiple) continue;
                    return resourceResults;
                }
                catch (RequiredConstraintFailureException | IllegalArgumentException | IllegalStateException e) {
                    LOGGER.warn("Exception encountered", (Throwable)e);
                }
            }
        }
        return resourceResults;
    }

    private void addToBundle(Bundle bundle, List<ResourceValue> objects) {
        if (objects != null && !objects.isEmpty()) {
            objects.forEach(obj -> this.addEntry(obj.getFHIRResourceType(), (ResourceValue)obj, bundle));
        }
    }

    private void addEntry(String resourceClass, ResourceValue obj, Bundle bundle) {
        try {
            if (obj != null) {
                LOGGER.info("Converting resourceName {} to FHIR {}", (Object)resourceClass, obj.getResource());
                String json = OBJ_MAPPER.writeValueAsString(obj.getResource());
                LOGGER.info("Adding resourceName {} to FHIR {}", (Object)resourceClass, (Object)json);
                if (json != null) {
                    Resource parsed = (Resource)this.context.getParser().parseResource(FHIRResourceMapper.getResourceClass(resourceClass), json);
                    bundle.addEntry().setResource(parsed).setFullUrl("urn:uuid:" + parsed.getId());
                }
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Processing exception when Serialization", (Throwable)e);
        }
    }

    @Override
    public FHIRContext getFHIRContext() {
        return this.context;
    }
}

