/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.message.util;

import ca.uhn.hl7v2.model.Structure;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.github.linuxforhealth.hl7.message.HL7Segment;
import io.github.linuxforhealth.hl7.message.util.SegmentGroup;
import io.github.linuxforhealth.hl7.parsing.HL7DataExtractor;
import io.github.linuxforhealth.hl7.parsing.result.ParsingResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentExtractorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HL7DataExtractor.class);

    private SegmentExtractorUtil() {
    }

    public static List<SegmentGroup> extractSegmentNonGroups(String segment, List<HL7Segment> additionalSegments, HL7DataExtractor dataExtractor) {
        LOGGER.debug("Extracting segment name {}", (Object)segment);
        ArrayList<SegmentGroup> returnValues = new ArrayList<SegmentGroup>();
        List<Structure> segments = SegmentExtractorUtil.getStructures(segment, dataExtractor);
        if (segments != null && !segments.isEmpty()) {
            Map<String, List<Structure>> additionalSegmentValues = SegmentExtractorUtil.extractAdditionalSegmentValueNonGroup(additionalSegments, dataExtractor);
            returnValues.add(new SegmentGroup(segments, additionalSegmentValues));
        }
        return returnValues;
    }

    public static List<SegmentGroup> extractSegmentGroups(List<String> primaryGroup, String primarySegment, List<HL7Segment> additionalSegments, HL7DataExtractor dataExtractor, List<String> parentGroup) {
        Preconditions.checkArgument((primaryGroup != null ? 1 : 0) != 0, (Object)"Groups list for segment to be extracted cannot be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)primarySegment), (Object)"primarySegment  cannot be null or blank.");
        LOGGER.debug("Extracting segment from group {} segment name {}", primaryGroup, (Object)primarySegment);
        if (parentGroup == null || parentGroup.isEmpty()) {
            List<Structure> parentSegments = SegmentExtractorUtil.getChildStructures(primaryGroup, dataExtractor);
            return SegmentExtractorUtil.generateSegmentGroup(primarySegment, primaryGroup, additionalSegments, dataExtractor, parentSegments, primaryGroup);
        }
        List<Structure> parentSegments = SegmentExtractorUtil.getChildStructures(parentGroup, dataExtractor);
        return SegmentExtractorUtil.generateSegmentGroup(primarySegment, primaryGroup, additionalSegments, dataExtractor, parentSegments, parentGroup);
    }

    private static List<SegmentGroup> generateSegmentGroup(String primarySegment, List<String> primaryGroup, List<HL7Segment> additionalSegments, HL7DataExtractor dataExtractor, List<Structure> parentSegments, List<String> parentGroupUsedForParentSegment) {
        ArrayList<SegmentGroup> returnValues = new ArrayList<SegmentGroup>();
        ArrayList<String> relativePrimaryGroups = null;
        relativePrimaryGroups = new ArrayList<String>(primaryGroup);
        relativePrimaryGroups.removeAll(parentGroupUsedForParentSegment);
        for (Structure parent : parentSegments) {
            List<Structure> primarySegments = SegmentExtractorUtil.getChildStructures(parent, relativePrimaryGroups, primarySegment, dataExtractor);
            for (Structure primary : primarySegments) {
                Map<String, List<Structure>> additionalSegmentValues = SegmentExtractorUtil.extractAdditionalSegmentValue(primary, primaryGroup, additionalSegments, dataExtractor);
                String groupId = SegmentExtractorUtil.generateGroupId(parent, parentGroupUsedForParentSegment);
                if (primarySegments == null || primarySegments.isEmpty()) continue;
                returnValues.add(new SegmentGroup(Lists.newArrayList((Object[])new Structure[]{primary}), additionalSegmentValues, groupId));
            }
        }
        return returnValues;
    }

    private static List<Structure> getChildStructures(Structure s, List<String> groups, String segment, HL7DataExtractor dataExtractor) {
        if (StringUtils.isBlank((CharSequence)segment)) {
            return new ArrayList<Structure>();
        }
        if (groups == null || groups.isEmpty()) {
            return SegmentExtractorUtil.getStructures(s, segment, dataExtractor);
        }
        List<Structure> parents = SegmentExtractorUtil.getChildStructures(s, groups, dataExtractor);
        ArrayList<Structure> returnValues = new ArrayList<Structure>();
        for (Structure parent : parents) {
            returnValues.addAll(SegmentExtractorUtil.getStructures(parent, segment, dataExtractor));
        }
        return returnValues;
    }

    private static List<Structure> getChildStructures(List<String> parentGroup, HL7DataExtractor dataExtractor) {
        if (parentGroup.isEmpty()) {
            return new ArrayList<Structure>();
        }
        if (parentGroup.size() == 1) {
            return SegmentExtractorUtil.getStructures(parentGroup.get(0), dataExtractor);
        }
        String parent = parentGroup.get(0);
        List<String> subParents = parentGroup.subList(1, parentGroup.size());
        List<Structure> segments = SegmentExtractorUtil.getStructures(parent, dataExtractor);
        ArrayList<Structure> results = new ArrayList<Structure>();
        for (Structure s : segments) {
            results.addAll(SegmentExtractorUtil.getChildStructures(s, subParents, dataExtractor));
        }
        return results;
    }

    private static List<Structure> getChildStructures(Structure parentStruct, List<String> parentGroup, HL7DataExtractor dataExtractor) {
        if (parentGroup.isEmpty()) {
            return Lists.newArrayList((Object[])new Structure[]{parentStruct});
        }
        if (parentStruct == null) {
            return new ArrayList<Structure>();
        }
        if (parentGroup.size() == 1) {
            return SegmentExtractorUtil.getStructures(parentStruct, parentGroup.get(0), dataExtractor);
        }
        String parent = parentGroup.get(0);
        List<String> subParents = parentGroup.subList(1, parentGroup.size());
        List<Structure> segments = SegmentExtractorUtil.getStructures(parentStruct, parent, dataExtractor);
        ArrayList<Structure> result = new ArrayList<Structure>();
        for (Structure s : segments) {
            result.addAll(SegmentExtractorUtil.getChildStructures(s, subParents, dataExtractor));
        }
        return result;
    }

    private static Map<String, List<Structure>> extractAdditionalSegmentValue(Structure primaryStruct, List<String> primaryGroups, List<HL7Segment> additionalSegments, HL7DataExtractor dataExtractor) {
        HashMap<String, List<Structure>> additionalSegmentValues = new HashMap<String, List<Structure>>();
        for (HL7Segment seg : additionalSegments) {
            List<Structure> values = SegmentExtractorUtil.extractEachAdditionalSegment(primaryStruct, primaryGroups, seg, dataExtractor);
            if (values == null || values.isEmpty()) continue;
            additionalSegmentValues.put(seg.getSegment(), values);
        }
        return additionalSegmentValues;
    }

    private static List<Structure> extractEachAdditionalSegment(Structure primaryStruct, List<String> primaryGroups, HL7Segment seg, HL7DataExtractor dataExtractor) {
        List<Structure> values = null;
        List<String> groups = seg.getGroup();
        if (groups.isEmpty()) {
            values = SegmentExtractorUtil.getStructures(seg.getSegment(), dataExtractor);
        } else if (primaryGroups.isEmpty()) {
            List<Structure> parentSegments = SegmentExtractorUtil.getChildStructures(seg.getGroup(), dataExtractor);
            values = new ArrayList<Structure>();
            for (Structure par : parentSegments) {
                values.addAll(SegmentExtractorUtil.getStructures(par, seg.getSegment(), dataExtractor));
            }
        } else if (CollectionUtils.containsAll(primaryGroups, groups)) {
            String commonParentGroup = SegmentExtractorUtil.getCommonParent(groups, primaryGroups);
            Structure commonParent = SegmentExtractorUtil.getParentGroup(primaryStruct, commonParentGroup);
            values = SegmentExtractorUtil.getStructures(commonParent, seg.getSegment(), dataExtractor);
        } else if (SegmentExtractorUtil.getCommonParent(groups, primaryGroups) != null) {
            String commonParentGroup = SegmentExtractorUtil.getCommonParent(groups, primaryGroups);
            Structure commonParent = SegmentExtractorUtil.getParentGroup(primaryStruct, commonParentGroup);
            ArrayList<String> relativeGroupsToCommonParent = new ArrayList<String>(groups);
            relativeGroupsToCommonParent.removeAll(primaryGroups);
            values = SegmentExtractorUtil.getChildStructures(commonParent, relativeGroupsToCommonParent, seg.getSegment(), dataExtractor);
        } else {
            List<Structure> parentSegments = SegmentExtractorUtil.getChildStructures(seg.getGroup(), dataExtractor);
            values = new ArrayList<Structure>();
            for (Structure par : parentSegments) {
                values.addAll(SegmentExtractorUtil.getStructures(par, seg.getSegment(), dataExtractor));
            }
        }
        return values;
    }

    private static String getCommonParent(List<String> groups, List<String> primaryGroups) {
        List common = groups.stream().filter(primaryGroups::contains).collect(Collectors.toList());
        if (!common.isEmpty()) {
            return (String)common.get(common.size() - 1);
        }
        return null;
    }

    private static Map<String, List<Structure>> extractAdditionalSegmentValueNonGroup(List<HL7Segment> additionalSegments, HL7DataExtractor dataExtractor) {
        HashMap<String, List<Structure>> additionalSegmentValues = new HashMap<String, List<Structure>>();
        for (HL7Segment seg : additionalSegments) {
            List<Structure> values = null;
            if (seg.isFromGroup()) {
                throw new IllegalStateException("Primary segment is not from a group, so additional segements cannot be from relative group.   ");
            }
            if (!seg.getGroup().isEmpty()) {
                throw new IllegalStateException("Additional segements cannot be from a group if primary segment is not defined to be from same group. ");
            }
            ParsingResult<Structure> result = dataExtractor.getAllStructures(seg.getSegment());
            values = result.getValues();
            if (values == null) continue;
            additionalSegmentValues.put(seg.getSegment(), values);
        }
        return additionalSegmentValues;
    }

    private static List<Structure> getStructures(String seg, HL7DataExtractor dataExtractor) {
        ParsingResult<Structure> segments = dataExtractor.getAllStructures(seg);
        if (segments == null || segments.isEmpty()) {
            return new ArrayList<Structure>();
        }
        return segments.getValues();
    }

    private static List<Structure> getStructures(Structure parent, String segment, HL7DataExtractor dataExtractor) {
        ParsingResult<Structure> segments = dataExtractor.getAllStructures(parent, segment);
        if (segments == null || segments.isEmpty()) {
            return new ArrayList<Structure>();
        }
        return segments.getValues();
    }

    private static String generateGroupId(Structure struct, List<String> groups) {
        Structure parent = SegmentExtractorUtil.getParentGroup(struct, groups);
        if (parent != null) {
            return parent.getName() + "_" + parent.hashCode();
        }
        return null;
    }

    private static Structure getParentGroup(Structure struct, List<String> groups) {
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        ArrayList<String> reversedGroups = new ArrayList<String>(groups);
        Collections.reverse(reversedGroups);
        Structure parent = struct;
        for (String eachSeg : reversedGroups) {
            parent = SegmentExtractorUtil.getParentGroup(parent, eachSeg);
        }
        if (parent != null) {
            return parent;
        }
        return null;
    }

    private static Structure getParentGroup(Structure struct, String group) {
        boolean parentMatchFound = false;
        Structure parent = struct;
        boolean noMoreParent = false;
        while (!parentMatchFound && !noMoreParent) {
            if (parent != null && StringUtils.endsWith((CharSequence)parent.getName(), (CharSequence)group)) {
                parentMatchFound = true;
                continue;
            }
            if (parent == null || parent.getName().equalsIgnoreCase(parent.getMessage().getName())) {
                noMoreParent = true;
                continue;
            }
            parent = parent.getParent();
        }
        if (parentMatchFound) {
            return parent;
        }
        return null;
    }
}

