/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.message.util;

import ca.uhn.hl7v2.model.Structure;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SegmentGroup {
    private String groupId;
    private List<Structure> segments;
    private Map<String, List<Structure>> additionalSegments;

    public SegmentGroup(Structure segment) {
        this(Lists.newArrayList((Object[])new Structure[]{segment}), new HashMap<String, List<Structure>>());
    }

    public SegmentGroup(List<Structure> segment, Map<String, List<Structure>> additionalSegments, String groupId) {
        Preconditions.checkArgument((segment != null && !segment.isEmpty() ? 1 : 0) != 0, (Object)"Segment cannot be null or empty");
        Preconditions.checkArgument((additionalSegments != null ? 1 : 0) != 0, (Object)"additionalSegments cannot be null");
        this.segments = new ArrayList<Structure>(segment);
        this.additionalSegments = new HashMap<String, List<Structure>>();
        this.additionalSegments.putAll(additionalSegments);
        this.groupId = groupId;
    }

    public SegmentGroup(List<Structure> segments, Map<String, List<Structure>> additionalSegments) {
        this(segments, additionalSegments, null);
    }

    public List<Structure> getSegments() {
        return ImmutableList.copyOf(this.segments);
    }

    public Structure getSegment() {
        return this.segments.get(0);
    }

    public Map<String, List<Structure>> getAdditionalSegments() {
        return ImmutableMap.copyOf(this.additionalSegments);
    }

    public Map<String, Structure> getAdditionalSegmentsSingleInstance() {
        HashMap<String, Structure> additionalSegmentsSingleInstance = new HashMap<String, Structure>();
        if (!this.additionalSegments.isEmpty()) {
            for (Map.Entry<String, List<Structure>> e : this.additionalSegments.entrySet()) {
                if (e.getValue() == null || e.getValue().isEmpty()) continue;
                additionalSegmentsSingleInstance.put(e.getKey(), e.getValue().get(0));
            }
        }
        return additionalSegmentsSingleInstance;
    }

    public String getGroupId() {
        return this.groupId;
    }
}

