/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.resource;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.Expression;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.ResourceModel;
import io.github.linuxforhealth.core.exception.DataExtractionException;
import io.github.linuxforhealth.core.exception.RequiredConstraintFailureException;
import io.github.linuxforhealth.core.resource.ResourceResult;
import io.github.linuxforhealth.core.resource.SimpleResourceValue;
import io.github.linuxforhealth.hl7.resource.ResourceEvaluationResult;
import io.github.linuxforhealth.hl7.resource.deserializer.HL7DataBasedResourceDeserializer;
import io.github.linuxforhealth.hl7.util.ExpressionUtility;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=HL7DataBasedResourceDeserializer.class)
public class HL7DataBasedResourceModel
implements ResourceModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(HL7DataBasedResourceModel.class);
    private Map<String, Expression> expressions = new HashMap<String, Expression>();
    private String spec;
    private String name;

    public HL7DataBasedResourceModel(String name, Map<String, Expression> expressions, String hl7spec) {
        this.expressions.putAll(expressions);
        this.spec = hl7spec;
        this.name = name;
    }

    public HL7DataBasedResourceModel(String name, Map<String, Expression> expressions) {
        this(name, expressions, null);
    }

    @Override
    public Map<String, Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public ResourceResult evaluate(InputDataExtractor dataSource, Map<String, EvaluationResult> context, EvaluationResult baseValue) {
        ResourceResult resources = null;
        try {
            ResourceEvaluationResult result = ExpressionUtility.evaluate(dataSource, context, baseValue, this.expressions);
            if (result != null && !result.getResolveValues().isEmpty()) {
                String groupId = HL7DataBasedResourceModel.getGroupId(context);
                resources = new ResourceResult(new SimpleResourceValue(result.getResolveValues(), this.name), result.getAdditionalResolveValues(), groupId);
            }
        }
        catch (RequiredConstraintFailureException e) {
            LOGGER.warn("Resource Constraint condition not satisfied for  {} , exception {}", (Object)this.name, (Object)e.getMessage());
            LOGGER.debug("Resource Constraint condition not satisfied for  {} , exception {}", (Object)this.name, (Object)e.toString());
            return null;
        }
        catch (DataExtractionException | IllegalArgumentException | IllegalStateException e) {
            LOGGER.error("Exception during  resource {} evaluation reason {}", (Object)this.name, (Object)e.toString());
            return null;
        }
        return resources;
    }

    private static String getGroupId(Map<String, EvaluationResult> localContext) {
        EvaluationResult result = localContext.get("GROUP_ID");
        if (result != null && result.getValue() instanceof String) {
            return (String)result.getValue();
        }
        return null;
    }

    public String getSpec() {
        return this.spec;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

