/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.resource.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.linuxforhealth.api.Expression;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import io.github.linuxforhealth.hl7.resource.HL7DataBasedResourceModel;
import io.github.linuxforhealth.hl7.resource.ResourceReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7DataBasedResourceDeserializer
extends JsonDeserializer<HL7DataBasedResourceModel> {
    private static final String RESOURCE_TYPE_FIELD_NAME = "resourceType";
    private static final String SPEC = "specs";
    private static Map<String, Expression> commonExpressions;
    private static final ObjectMapper MAPPER;
    private static final Logger LOGGER;

    private static synchronized Map<String, Expression> getCommonExpressions() throws JsonProcessingException {
        if (commonExpressions == null) {
            commonExpressions = new HashMap<String, Expression>();
            String path = ResourceReader.getInstance().getResource("hl7/resource/Common.yml");
            JsonNode node = ObjectMapperUtil.getYAMLInstance().readTree(path);
            Map<String, Expression> expressions = HL7DataBasedResourceDeserializer.generateExpressions(node);
            commonExpressions.putAll(expressions);
        }
        return commonExpressions;
    }

    public HL7DataBasedResourceModel deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        ObjectNode node = (ObjectNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode hl7PrefixNode = node.get(SPEC);
        String hl7Prefix = null;
        if (hl7PrefixNode != null) {
            hl7Prefix = hl7PrefixNode.toString();
        }
        Map<String, Expression> expressions = HL7DataBasedResourceDeserializer.generateExpressions((JsonNode)node);
        JsonNode namenode = node.get(RESOURCE_TYPE_FIELD_NAME);
        String name = String.valueOf(ctxt.findInjectableValue((Object)"resourceName", null, null));
        if (namenode != null) {
            name = namenode.textValue();
        }
        if (!expressions.isEmpty() && name.indexOf("/") == -1) {
            LOGGER.debug("Adding common expressions to the list of expressions for {}", (Object)name);
            expressions.putAll(HL7DataBasedResourceDeserializer.getCommonExpressions());
        }
        return new HL7DataBasedResourceModel(name, expressions, hl7Prefix);
    }

    private static Map<String, Expression> generateExpressions(JsonNode node) {
        HashMap<String, Expression> expressions = new HashMap<String, Expression>();
        Iterator iter = node.fields();
        while (iter.hasNext()) {
            Expression e;
            Map.Entry entry = (Map.Entry)iter.next();
            LOGGER.debug("deserealizing {}", (Object)entry);
            ExpressionAttributes expAttr = (ExpressionAttributes)MAPPER.convertValue(entry.getValue(), ExpressionAttributes.class);
            if (expAttr == null || expAttr.getExpressionType() == null) continue;
            expAttr.setName((String)entry.getKey());
            try {
                e = HL7DataBasedResourceDeserializer.generateExpression(expAttr);
            }
            catch (IllegalStateException e1) {
                LOGGER.error("deserialization failure {} expression type {}", new Object[]{entry, expAttr.getExpressionType(), e1});
                e = null;
            }
            if (e != null) {
                expressions.put((String)entry.getKey(), e);
            }
            LOGGER.debug("deserialized {} expression type {}", (Object)entry, (Object)e);
        }
        return expressions;
    }

    public static Expression generateExpression(ExpressionAttributes expAttr) {
        if (expAttr != null && expAttr.getExpressionType() != null) {
            try {
                Constructor<? extends Expression> ctor = expAttr.getExpressionType().getEvaluator().getConstructor(ExpressionAttributes.class);
                return ctor.newInstance(expAttr);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
                throw new IllegalStateException("Error encountered while creating expression object.", e1);
            }
        }
        return null;
    }

    static {
        MAPPER = ObjectMapperUtil.getYAMLInstance();
        LOGGER = LoggerFactory.getLogger(HL7DataBasedResourceDeserializer.class);
    }
}

