/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.util;

import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.Expression;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.core.exception.DataExtractionException;
import io.github.linuxforhealth.core.exception.RequiredConstraintFailureException;
import io.github.linuxforhealth.core.expression.EmptyEvaluationResult;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.hl7.resource.ResourceEvaluationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionUtility {
    private static final String KEY_NAME_SUFFIX = "KEY_NAME_SUFFIX";
    private static final String EVALUATING = "Evaluating {} {}";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionUtility.class);

    private ExpressionUtility() {
    }

    public static ResourceEvaluationResult evaluate(InputDataExtractor dataSource, Map<String, EvaluationResult> context, EvaluationResult baseValue, Map<String, Expression> expressionMap) {
        try {
            HashMap<String, EvaluationResult> localContext = new HashMap<String, EvaluationResult>(context);
            ArrayList<ResourceValue> additionalResolveValues = new ArrayList<ResourceValue>();
            HashMap<String, Object> resolveValues = new HashMap<String, Object>();
            for (Map.Entry<String, Expression> entry : expressionMap.entrySet()) {
                Expression exp = entry.getValue();
                LOGGER.debug(EVALUATING, (Object)entry.getKey(), (Object)entry.getValue());
                EvaluationResult obj = exp.evaluate(dataSource, localContext, baseValue);
                LOGGER.debug("Evaluated {} {} value returned {} ", new Object[]{entry.getKey(), entry.getValue(), obj});
                if (obj == null || obj.isEmpty()) continue;
                String keyNameSuffix = ExpressionUtility.getKeyNameSuffix(localContext);
                if (!resolveValues.containsKey(ExpressionUtility.getKeyName(entry.getKey(), keyNameSuffix))) {
                    resolveValues.put(ExpressionUtility.getKeyName(entry.getKey(), keyNameSuffix), obj.getValue());
                } else {
                    Object existing = resolveValues.get(ExpressionUtility.getKeyName(entry.getKey(), keyNameSuffix));
                    if (existing instanceof List) {
                        if (obj.getValue() instanceof List) {
                            ((List)existing).addAll((Collection)obj.getValue());
                        } else {
                            ((List)existing).add(obj.getValue());
                        }
                    }
                }
                if (obj.getAdditionalResources() == null || obj.getAdditionalResources().isEmpty()) continue;
                additionalResolveValues.addAll(obj.getAdditionalResources());
            }
            resolveValues.values().removeIf(Objects::isNull);
            return new ResourceEvaluationResult(resolveValues, additionalResolveValues);
        }
        catch (RequiredConstraintFailureException e) {
            LOGGER.warn("Resource Constraint condition not satisfied , exception {}", (Object)e.getMessage());
            LOGGER.debug("Resource Constraint condition not satisfied, exception", (Throwable)e);
            return null;
        }
        catch (DataExtractionException | IllegalArgumentException | IllegalStateException e) {
            LOGGER.error("Exception during  resource evaluation reason ", (Throwable)e);
            return null;
        }
    }

    private static String getKeyName(String key, String suffix) {
        String[] keyComponents = StringUtils.split((String)key, (String)"_", (int)2);
        if (keyComponents.length == 2 && KEY_NAME_SUFFIX.equalsIgnoreCase(keyComponents[1])) {
            return keyComponents[0] + suffix;
        }
        return keyComponents[0];
    }

    private static String getKeyNameSuffix(Map<String, EvaluationResult> localContext) {
        EvaluationResult res = localContext.get(KEY_NAME_SUFFIX);
        if (res == null || res.isEmpty()) {
            return null;
        }
        return (String)res.getValue();
    }

    public static EvaluationResult extractComponent(ImmutablePair<String, String> fetch, EvaluationResult resource) {
        if (resource != null && resource.getValue() instanceof ResourceValue) {
            ResourceValue rv = (ResourceValue)resource.getValue();
            Map<String, Object> resourceMap = rv.getResource();
            return EvaluationResultFactory.getEvaluationResult(resourceMap.get(fetch.getValue()));
        }
        if (resource != null && resource.getValue() instanceof Map) {
            Map resourceMap = (Map)resource.getValue();
            return EvaluationResultFactory.getEvaluationResult(resourceMap.get(fetch.getValue()));
        }
        if (resource != null && !resource.isEmpty()) {
            Map resourceMap = (Map)ObjectMapperUtil.getJSONInstance().convertValue(resource.getValue(), Map.class);
            return EvaluationResultFactory.getEvaluationResult(resourceMap.get(fetch.getValue()));
        }
        return new EmptyEvaluationResult();
    }
}

