/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileSystem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDirectoryLocationStrategy
implements FileLocationStrategy {
    private static final String CONF_PROP_HOME_SYSTEM_PROP = "hl7converter.config.home";
    private static final String CONF_PROP_HOME_ENV_VAR = "HL7CONVERTER_CONFIG_HOME";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigDirectoryLocationStrategy.class);
    private final String confDirectory = ConfigDirectoryLocationStrategy.fetchHomeDirectory();

    public String getConfDirectory() {
        return this.confDirectory;
    }

    public URL locate(FileSystem fileSystem, FileLocator locator) {
        if (StringUtils.isNotEmpty((CharSequence)locator.getFileName()) && this.confDirectory != null) {
            LOGGER.info("Looking for config file in location {} based on config.home system property.", (Object)this.confDirectory);
            File file = new File(this.confDirectory, locator.getFileName());
            if (file.isFile()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        }
        return null;
    }

    private static String fetchHomeDirectory() {
        String homeDirectory = System.getenv(CONF_PROP_HOME_ENV_VAR);
        if (homeDirectory == null || homeDirectory.trim().isEmpty()) {
            return System.getProperty(CONF_PROP_HOME_SYSTEM_PROP);
        }
        return homeDirectory;
    }
}

