/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.config;

import io.github.linuxforhealth.core.config.ConfigDirectoryLocationStrategy;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.PropertiesBuilderParameters;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ClasspathLocationStrategy;
import org.apache.commons.configuration2.io.CombinedLocationStrategy;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConverterConfiguration.class);
    private static final String SUPPORTED_HL7_MESSAGES = "supported.hl7.messages";
    private static final String BASE_PATH_RESOURCE = "base.path.resource";
    private static final String DEFAULT_ZONE_ID = "default.zoneid";
    private static final String CONFIG_PROPERTIES = "config.properties";
    private static final String ADDITIONAL_CONCEPT_MAPS_FILE = "additional.conceptmap.file";
    private static final String ADDITIONAL_RESOURCES_LOCATION = "additional.resources.location";
    private static ConverterConfiguration configuration;
    private String resourceFolder;
    private boolean resourcefromClassPath;
    private List<String> supportedMessageTemplates;
    private ZoneId zoneId;
    private String additionalConceptmapFile;
    private String additionalResourcesLocation;

    private ConverterConfiguration() {
        try {
            List<FileLocationStrategy> subs = Arrays.asList(new ConfigDirectoryLocationStrategy(), new ClasspathLocationStrategy());
            CombinedLocationStrategy strategy = new CombinedLocationStrategy(subs);
            Parameters params = new Parameters();
            FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)((PropertiesBuilderParameters)params.properties().setFileName(CONFIG_PROPERTIES)).setThrowExceptionOnMissing(true)).setLocationStrategy((FileLocationStrategy)strategy)).setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','))});
            Configuration config = (Configuration)builder.getConfiguration();
            String resourceLoc = config.getString(BASE_PATH_RESOURCE, null);
            if (StringUtils.isNotBlank((CharSequence)resourceLoc)) {
                this.resourceFolder = resourceLoc;
            } else {
                this.resourceFolder = "";
                this.resourcefromClassPath = true;
            }
            List values = config.getList(SUPPORTED_HL7_MESSAGES, null);
            this.supportedMessageTemplates = values != null ? values.stream().filter(v -> v != null && StringUtils.isNotBlank((CharSequence)v.toString())).map(v -> v.toString()).collect(Collectors.toList()) : new ArrayList<String>(Arrays.asList("*"));
            String zoneText = config.getString(DEFAULT_ZONE_ID, null);
            if (StringUtils.isNotBlank((CharSequence)zoneText)) {
                this.getZoneId(zoneText);
            }
            this.additionalConceptmapFile = config.getString(ADDITIONAL_CONCEPT_MAPS_FILE, null);
            this.additionalResourcesLocation = config.getString(ADDITIONAL_RESOURCES_LOCATION, null);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("Cannot read configuration for resource location", e);
        }
    }

    private void getZoneId(String zoneText) {
        try {
            this.zoneId = ZoneId.of(zoneText);
        }
        catch (DateTimeException e) {
            LOGGER.warn("Cannot create ZoneId");
            this.zoneId = null;
        }
    }

    public static ConverterConfiguration getInstance() {
        if (configuration == null) {
            configuration = new ConverterConfiguration();
        }
        return configuration;
    }

    public static void reset() {
        configuration = null;
    }

    public String getResourceFolder() {
        return this.resourceFolder;
    }

    public boolean isResourcefromClassPath() {
        return this.resourcefromClassPath;
    }

    public void setResourcefromClassPath(boolean resourcefromClassPath) {
        this.resourcefromClassPath = resourcefromClassPath;
    }

    public List<String> getSupportedMessageTemplates() {
        return this.supportedMessageTemplates;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public String getAdditionalConceptmapFile() {
        return this.additionalConceptmapFile;
    }

    public String getAdditionalResourcesLocation() {
        return this.additionalResourcesLocation;
    }
}

