/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.expression;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.core.expression.VariableUtils;
import io.github.linuxforhealth.hl7.expression.specification.SimpleSpecification;
import io.github.linuxforhealth.hl7.util.ExpressionUtility;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ContextValueUtils {
    public static Object getSingleValue(Object object) {
        if (object instanceof List) {
            List value = (List)object;
            if (value.isEmpty()) {
                return null;
            }
            return value.get(0);
        }
        return object;
    }

    public static String getGroupId(Map<String, EvaluationResult> localContext) {
        EvaluationResult result = localContext.get("GROUP_ID");
        if (result != null) {
            return (String)result.getValue();
        }
        return null;
    }

    public static String getKeyName(Map<String, EvaluationResult> contextValues, String key, boolean useGroup) {
        EvaluationResult result = contextValues.get("useGroup");
        if (result != null && !result.isEmpty()) {
            useGroup = (Boolean)result.getValue();
        }
        if (useGroup) {
            String groupId = ContextValueUtils.getGroupId(contextValues);
            return key + "_" + groupId;
        }
        return key;
    }

    public static EvaluationResult getVariableValuesFromVariableContextMap(String varName, Map<String, EvaluationResult> contextValues, boolean isUseGroup, boolean fuzzyMatch) {
        Preconditions.checkArgument((!isUseGroup || !fuzzyMatch ? 1 : 0) != 0, (Object)"Both use group and fuzzyMatch cannot be true");
        if (StringUtils.isNotBlank((CharSequence)varName)) {
            EvaluationResult fetchedValue;
            if (varName.startsWith("$") && varName.contains(":")) {
                return ContextValueUtils.fetchValueFromVar(varName, contextValues, isUseGroup);
            }
            if (fuzzyMatch) {
                fetchedValue = ContextValueUtils.getPrefixedValues(VariableUtils.getVarName(varName), contextValues);
            } else if (isUseGroup) {
                String keyname = ContextValueUtils.getKeyName(contextValues, VariableUtils.getVarName(varName), isUseGroup);
                fetchedValue = contextValues.get(keyname);
                if (fetchedValue == null) {
                    fetchedValue = contextValues.get(VariableUtils.getVarName(varName));
                }
            } else {
                fetchedValue = contextValues.get(VariableUtils.getVarName(varName));
            }
            return fetchedValue;
        }
        return null;
    }

    private static EvaluationResult getPrefixedValues(String keyname, Map<String, EvaluationResult> contextValues) {
        List obj = contextValues.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(keyname) && e.getValue() != null && !((EvaluationResult)e.getValue()).isEmpty()).map(e -> ((EvaluationResult)e.getValue()).getValue()).collect(Collectors.toList());
        return EvaluationResultFactory.getEvaluationResult(obj);
    }

    private static EvaluationResult fetchValueFromVar(String varName, Map<String, EvaluationResult> contextValues, boolean isUseGroup) {
        String[] tokens = StringUtils.split((String)varName, (String)":", (int)2);
        ImmutablePair fetch = ImmutablePair.of((Object)tokens[0], (Object)tokens[1]);
        String keyname = ContextValueUtils.getKeyName(contextValues, VariableUtils.getVarName((String)fetch.left), isUseGroup);
        EvaluationResult resource = contextValues.get(keyname);
        return ExpressionUtility.extractComponent((ImmutablePair<String, String>)fetch, resource);
    }

    public static EvaluationResult getVariableValueFromVariableContextMap(SimpleSpecification simpleSpec, Map<String, EvaluationResult> contextValues) {
        return ContextValueUtils.getVariableValuesFromVariableContextMap(simpleSpec.getVariable(), contextValues, simpleSpec.isUseGroup(), simpleSpec.isFuzzyMatch());
    }
}

