/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.expression;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;

public class VariableUtils {
    private VariableUtils() {
    }

    public static boolean isVar(String hl7spec) {
        return StringUtils.isNotBlank((CharSequence)hl7spec) && hl7spec.startsWith("$") && hl7spec.length() > 1;
    }

    public static String getVarName(String name) {
        String varName = name;
        if (VariableUtils.isVar(name) && StringUtils.contains((CharSequence)name, (CharSequence)".")) {
            StringTokenizer stk = new StringTokenizer(name, ".");
            varName = StringUtils.removeStart((String)stk.nextToken(), (String)"$");
        } else if (VariableUtils.isVar(name)) {
            varName = StringUtils.removeStart((String)name, (String)"$");
        }
        if (StringUtils.endsWith((CharSequence)varName, (CharSequence)"?")) {
            varName = StringUtils.removeEnd((String)varName, (String)"?");
        }
        return varName;
    }

    public static boolean isFuzzyMatch(String value) {
        return StringUtils.isNotBlank((CharSequence)value) && value.endsWith("?");
    }
}

