/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.expression.condition;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.Condition;
import io.github.linuxforhealth.api.EvaluationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CompoundAndCondition
implements Condition {
    private List<Condition> conditions;

    public CompoundAndCondition(List<Condition> conditions) {
        Preconditions.checkArgument((conditions != null && !conditions.isEmpty() ? 1 : 0) != 0, (Object)"conditions cannot be null or empty");
        this.conditions = conditions;
    }

    @Override
    public boolean test(Map<String, EvaluationResult> contextVariables) {
        for (Condition c : this.conditions) {
            if (c.test(contextVariables)) continue;
            return false;
        }
        return true;
    }

    public List<Condition> getConditions() {
        return new ArrayList<Condition>(this.conditions);
    }
}

