/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.expression.condition;

import io.github.linuxforhealth.core.expression.condition.ConditionBiPredicates;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.EnumUtils;

public enum ConditionPredicateEnum {
    GREATER_THAN_INTEGER(ConditionBiPredicates.GREATER_THAN, Integer.class, Integer.class),
    EQUALS_INTEGER(ConditionBiPredicates.EQUAL_TO, Integer.class, Integer.class),
    NOT_EQUALS_INTEGER(ConditionBiPredicates.NOT_EQUAL_TO, Integer.class, Integer.class),
    LESS_THAN_INTEGER(ConditionBiPredicates.LESS_THAN, Integer.class, Integer.class),
    GREATER_THAN_OR_EQUAL_TO_INTEGER(ConditionBiPredicates.GREATER_THAN_OR_EQUAL_TO, Integer.class, Integer.class),
    LESS_THAN_OR_EQUAL_TO_INTEGER(ConditionBiPredicates.LESS_THAN_OR_EQUAL_TO, Integer.class, Integer.class),
    CONTAINS_STRING(ConditionBiPredicates.CONTAINS, String.class, String.class),
    NOT_CONTAINS_STRING(ConditionBiPredicates.NOT_CONTAINS, String.class, String.class),
    EQUALS_STRING(ConditionBiPredicates.EQUALS_IC, String.class, String.class),
    NOT_EQUALS_STRING(ConditionBiPredicates.NOT_EQUALS, String.class, String.class),
    STARTS_WITH_STRING(ConditionBiPredicates.STARTS_WITH, String.class, String.class),
    NOT_STARTS_WITH_STRING(ConditionBiPredicates.NOT_STARTS_WITH, String.class, String.class),
    ENDS_WITH_STRING(ConditionBiPredicates.ENDS_WITH, String.class, String.class),
    NOT_ENDS_WITH_STRING(ConditionBiPredicates.NOT_ENDS_WITH, String.class, String.class);

    private BiPredicate<?, ?> predicate;
    private Class<?> klassT;
    private Class<?> klassU;

    private ConditionPredicateEnum(BiPredicate<?, ?> p, Class<?> klassT, Class<?> klassU) {
        this.predicate = p;
        this.klassT = klassT;
        this.klassU = klassU;
    }

    public BiPredicate getPredicate() {
        return this.predicate;
    }

    public Class<?> getKlassT() {
        return this.klassT;
    }

    public Class<?> getKlassU() {
        return this.klassU;
    }

    public static ConditionPredicateEnum getConditionPredicate(String conditionOperator, String klassSimpleName) {
        String klassAdjustedName = klassSimpleName.equalsIgnoreCase("ST") || klassSimpleName.equalsIgnoreCase("IS") || klassSimpleName.equalsIgnoreCase("NULLDT") ? "STRING" : klassSimpleName.toUpperCase();
        String enumName = conditionOperator.endsWith(klassAdjustedName) ? conditionOperator : conditionOperator + "_" + klassSimpleName;
        return (ConditionPredicateEnum)EnumUtils.getEnumIgnoreCase(ConditionPredicateEnum.class, (String)enumName);
    }
}

