/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.resource;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.ResourceValue;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SimpleResourceValue
implements ResourceValue {
    private Map<String, Object> resource;
    private String resourceClass;

    public SimpleResourceValue(Map<String, Object> resource, String resourceClass) {
        Preconditions.checkArgument((resource != null && !resource.isEmpty() ? 1 : 0) != 0, (Object)"resource cannot be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)resourceClass), (Object)"resourceName cannot be null or blank.");
        this.resource = resource;
        this.resourceClass = resourceClass;
    }

    @Override
    public Map<String, Object> getResource() {
        return this.resource;
    }

    @Override
    public String getFHIRResourceType() {
        return this.resourceClass;
    }

    @Override
    public boolean isEmpty() {
        return this.resource == null || this.resource.isEmpty();
    }
}

