/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.terminology;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.hl7.resource.ResourceReader;
import java.io.IOException;
import java.util.Map;

public class Hl7v2Mapping {
    private Map<String, Map<String, String>> mapping;
    private static Hl7v2Mapping hl7Mapping;

    private Hl7v2Mapping() {
        try {
            this.mapping = Hl7v2Mapping.loadV2Mappings();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot initialize mapping", e);
        }
    }

    private static Map<String, Map<String, String>> loadV2Mappings() throws IOException {
        TypeReference<Map<String, Map<String, String>>> typeRef = new TypeReference<Map<String, Map<String, String>>>(){};
        String content = ResourceReader.getInstance().getResourceInHl7Folder("codesystem/v2ToFhirMapping.yml");
        return (Map)ObjectMapperUtil.getYAMLInstance().readValue(content, (TypeReference)typeRef);
    }

    public static Map<String, String> getMapping(String fhirConceptName) {
        if (hl7Mapping == null) {
            hl7Mapping = new Hl7v2Mapping();
        }
        return Hl7v2Mapping.hl7Mapping.mapping.get(fhirConceptName);
    }
}

