/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.terminology;

import com.google.common.collect.ImmutableMap;
import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.registry.FHIRRegistry;
import com.ibm.fhir.term.service.FHIRTermService;
import com.ibm.fhir.term.service.LookupOutcome;
import io.github.linuxforhealth.core.terminology.SimpleCode;
import io.github.linuxforhealth.core.terminology.UrlLookup;
import java.util.Map;

public class TerminologyLookup {
    private static final FHIRRegistry REGISTRY = FHIRRegistry.getInstance();
    private static final FHIRTermService TERMINOLOGY_SEVICE = FHIRTermService.getInstance();
    private static TerminologyLookup termInstance;
    static Map<String, String> alternativeCodingSystemMapping;

    private TerminologyLookup() {
    }

    public static SimpleCode lookup(String system, String value) {
        Uri url;
        String codingSystemName = system;
        if (alternativeCodingSystemMapping.containsKey(system)) {
            codingSystemName = alternativeCodingSystemMapping.get(system);
        }
        if ((url = TerminologyLookup.getSystemUrl(codingSystemName)) != null) {
            Code c = Code.of((String)value);
            LookupOutcome outcome = TERMINOLOGY_SEVICE.lookup(url, null, c);
            if (outcome != null && outcome.getDisplay() != null) {
                return new SimpleCode(value, url.getValue(), outcome.getDisplay().getValue());
            }
            CodeSystem s = null;
            s = (CodeSystem)REGISTRY.getResource(url.getValue(), CodeSystem.class);
            if (s != null && s.getUrl() != null) {
                return new SimpleCode(value, url.getValue(), null);
            }
            return new SimpleCode(value, url.getValue(), "");
        }
        return null;
    }

    private static Uri getSystemUrl(String value) {
        String sys = UrlLookup.getSystemUrl(value);
        return sys != null ? Uri.uri((String)sys) : null;
    }

    public static void init() {
        if (termInstance == null) {
            termInstance = new TerminologyLookup();
        }
    }

    static {
        alternativeCodingSystemMapping = ImmutableMap.of((Object)"v2-0005", (Object)"v3-Race", (Object)"CDCREC", (Object)"v3-Race");
    }
}

