/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.terminology;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.core.config.ConverterConfiguration;
import io.github.linuxforhealth.core.terminology.CodingSystem;
import io.github.linuxforhealth.hl7.resource.ResourceReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class UrlLookup {
    static Map<String, Map<String, CodingSystem>> urlMaps = new HashMap<String, Map<String, CodingSystem>>();
    static Map<String, String> urlMappingPaths = new HashMap<String, String>();

    public static String getExtensionUrl(String value) {
        return UrlLookup.getUrl("ExtensionUrl", value);
    }

    public static String getSystemUrl(String value) {
        return UrlLookup.getUrl("CodingSystem", value);
    }

    public static String getAssociatedUrl(String value) {
        String url = UrlLookup.getUrl("CodingSystem", value);
        if (url == null) {
            url = UrlLookup.getUrl("ExtensionUrl", value);
        }
        return url;
    }

    public static String getUrl(String urlType, String value) {
        CodingSystem system;
        Map<String, CodingSystem> urlMap = UrlLookup.getUrlMap(urlType);
        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"http://") || StringUtils.startsWith((CharSequence)value, (CharSequence)"https://") || StringUtils.startsWith((CharSequence)value, (CharSequence)"urn")) {
            return value;
        }
        if (value != null && (system = urlMap.get(StringUtils.upperCase((String)value))) != null) {
            return system.getUrl();
        }
        return null;
    }

    public static void reset() {
        urlMaps.clear();
        UrlLookup.getUrlMap("CodingSystem");
        UrlLookup.getUrlMap("ExtensionUrl");
    }

    public static void init() {
        UrlLookup.getUrlMap("CodingSystem");
        UrlLookup.getUrlMap("ExtensionUrl");
    }

    public static void reset(String urlType) {
        urlMaps.remove(urlType);
        UrlLookup.getUrlMap(urlType);
    }

    private static Map<String, CodingSystem> getUrlMap(String urlKey) {
        if (urlMaps.get(urlKey) == null) {
            Map<String, CodingSystem> urls = UrlLookup.loadFromFile(urlKey);
            urls.putAll(UrlLookup.loadAdditionalFromFile());
            urlMaps.put(urlKey, urls);
        }
        return urlMaps.get(urlKey);
    }

    private static Map<String, CodingSystem> loadFromFile(String urlKey) {
        TypeReference<List<CodingSystem>> typeRef = new TypeReference<List<CodingSystem>>(){};
        try {
            String content = ResourceReader.getInstance().getResourceInHl7Folder(urlMappingPaths.get(urlKey));
            List systems = (List)ObjectMapperUtil.getYAMLInstance().readValue(content, (TypeReference)typeRef);
            return systems.stream().collect(Collectors.toMap(CodingSystem::getId, codeSystem -> codeSystem));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read extension/ExtensionUrlMapping.yml", e);
        }
    }

    private static Map<String, CodingSystem> loadAdditionalFromFile() {
        TypeReference<List<CodingSystem>> typeRef = new TypeReference<List<CodingSystem>>(){};
        String filePath = ConverterConfiguration.getInstance().getAdditionalConceptmapFile();
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            try {
                FileInputStream fis = new FileInputStream(filePath);
                List systems = (List)ObjectMapperUtil.getYAMLInstance().readValue((InputStream)fis, (TypeReference)typeRef);
                return systems.stream().collect(Collectors.toMap(CodingSystem::getId, codeSystem -> codeSystem));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(filePath, e);
            }
        }
        return new HashMap<String, CodingSystem>();
    }

    static {
        urlMappingPaths.put("CodingSystem", "codesystem/CodingSystemMapping.yml");
        urlMappingPaths.put("ExtensionUrl", "codesystem/ExtensionUrlMapping.yml");
    }
}

