/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FHIRContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(FHIRContext.class);
    private static final FhirContext CTX = FhirContext.forR4();
    private IParser parser = CTX.newJsonParser();
    private static FhirValidator validator;
    private boolean validateResource;
    private HashMap<String, String> properties;
    private String zoneIdText;

    public FHIRContext(boolean isPrettyPrint, boolean validateResource, Map<String, String> properties, String zoneIdText) {
        this.parser.setPrettyPrint(isPrettyPrint);
        this.validateResource = validateResource;
        this.properties = (HashMap)properties;
        this.zoneIdText = zoneIdText;
    }

    public FHIRContext(boolean isPrettyPrint, boolean validateResource) {
        this(isPrettyPrint, validateResource, new HashMap<String, String>(), null);
    }

    public FHIRContext() {
        this(false, false, new HashMap<String, String>(), null);
    }

    public IParser getParser() {
        return this.parser;
    }

    public FhirContext getCtx() {
        return CTX;
    }

    public static FhirValidator getValidator() {
        FHIRContext.initValidator();
        return validator;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getZoneIdText() {
        return this.zoneIdText;
    }

    public String encodeResourceToString(Bundle bundle) {
        return this.parser.encodeResourceToString((IBaseResource)bundle);
    }

    public void validate(Bundle bundle) {
        if (this.validateResource) {
            ValidationResult result = FHIRContext.getValidator().validateWithResult((IBaseResource)bundle);
            ArrayList<CallSite> validationIssues = new ArrayList<CallSite>();
            for (SingleValidationMessage next : result.getMessages()) {
                if (ResultSeverityEnum.FATAL == next.getSeverity() || ResultSeverityEnum.ERROR == next.getSeverity()) {
                    validationIssues.add((CallSite)((Object)(next.getLocationString() + " " + next.getMessage() + " " + next.getSeverity())));
                    LOGGER.error("Validation issues: {}", (Object)next.getSeverity());
                } else {
                    LOGGER.warn("Validation issues: {}", (Object)next.getSeverity());
                }
                if (validationIssues.isEmpty()) continue;
                throw new IllegalArgumentException("Validation issues encountered. " + StringUtils.join(validationIssues, (String)"|"));
            }
        }
    }

    private static void initValidator() {
        if (validator == null) {
            validator = CTX.newValidator();
            FhirInstanceValidator module = new FhirInstanceValidator(CTX);
            validator.registerValidatorModule((IValidatorModule)module);
        }
    }
}

