/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.core.Constants;
import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.r4.model.Bundle;

public class ConverterOptions {
    public static final ConverterOptions SIMPLE_OPTIONS = new Builder().build();
    private Bundle.BundleType bundleType;
    private boolean prettyPrint;
    private boolean validateResource;
    private String zoneIdText;
    private HashMap<String, String> properties;

    private ConverterOptions(Builder builder) {
        this.bundleType = builder.bundleType != null ? builder.bundleType : Constants.DEFAULT_BUNDLE_TYPE;
        this.zoneIdText = builder.zoneIdText;
        this.properties = builder.properties;
        this.prettyPrint = builder.prettyPrint;
        this.validateResource = builder.validateResource;
    }

    public Bundle.BundleType getBundleType() {
        return this.bundleType;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public boolean isValidateResource() {
        return this.validateResource;
    }

    public String getZoneIdText() {
        return this.zoneIdText;
    }

    public String getProperty(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Property key cannot be null");
        return this.properties.get(key);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static class Builder {
        private Bundle.BundleType bundleType;
        private boolean prettyPrint;
        private boolean validateResource;
        private String zoneIdText;
        private HashMap<String, String> properties = new HashMap();

        public Builder withBundleType(Bundle.BundleType bundleType) {
            Preconditions.checkArgument((bundleType != null ? 1 : 0) != 0, (Object)"Bundle type cannot be null");
            this.bundleType = bundleType;
            return this;
        }

        public Builder withPrettyPrint() {
            this.prettyPrint = true;
            return this;
        }

        public Builder withValidateResource() {
            this.validateResource = true;
            return this;
        }

        public Builder withZoneIdText(String zoneIdText) {
            Preconditions.checkArgument((zoneIdText != null ? 1 : 0) != 0, (Object)"zoneIdText cannot be null");
            this.zoneIdText = zoneIdText;
            return this;
        }

        public Builder withProperty(String key, String value) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Property key cannot be null");
            Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"Property value cannot be null");
            this.properties.put(key, value);
            return this;
        }

        public ConverterOptions build() {
            return new ConverterOptions(this);
        }
    }
}

