/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Hl7InputStreamMessageStringIterator;
import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.MessageEngine;
import io.github.linuxforhealth.core.terminology.TerminologyLookup;
import io.github.linuxforhealth.core.terminology.UrlLookup;
import io.github.linuxforhealth.fhir.FHIRContext;
import io.github.linuxforhealth.hl7.ConverterOptions;
import io.github.linuxforhealth.hl7.message.HL7MessageEngine;
import io.github.linuxforhealth.hl7.message.HL7MessageModel;
import io.github.linuxforhealth.hl7.parsing.HL7DataExtractor;
import io.github.linuxforhealth.hl7.parsing.HL7HapiParser;
import io.github.linuxforhealth.hl7.resource.ResourceReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7ToFHIRConverter {
    private static HL7HapiParser hparser = new HL7HapiParser();
    private static final Logger LOGGER = LoggerFactory.getLogger(HL7ToFHIRConverter.class);
    private Map<String, HL7MessageModel> messagetemplates = new HashMap<String, HL7MessageModel>();

    public HL7ToFHIRConverter() {
        try {
            this.messagetemplates.putAll(ResourceReader.getInstance().getMessageTemplates());
            TerminologyLookup.init();
            UrlLookup.init();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Failure to initialize the templates for the converter.", e);
        }
    }

    public String convert(File hl7MessageFile) throws IOException {
        Preconditions.checkArgument((hl7MessageFile != null ? 1 : 0) != 0, (Object)"Input HL7 message file cannot be null.");
        return this.convert(hl7MessageFile, ConverterOptions.SIMPLE_OPTIONS);
    }

    public String convert(File hl7MessageFile, ConverterOptions options) throws IOException {
        Preconditions.checkArgument((hl7MessageFile != null ? 1 : 0) != 0, (Object)"Input HL7 message file cannot be null.");
        return this.convert(FileUtils.readFileToString((File)hl7MessageFile, (Charset)StandardCharsets.UTF_8), options);
    }

    public String convert(String hl7MessageData) {
        return this.convert(hl7MessageData, ConverterOptions.SIMPLE_OPTIONS);
    }

    public String convert(String hl7MessageData, ConverterOptions options) {
        HL7MessageEngine engine = this.getMessageEngine(options);
        Bundle bundle = this.convertToBundle(hl7MessageData, options, engine);
        return engine.getFHIRContext().encodeResourceToString(bundle);
    }

    public Bundle convertToBundle(String hl7MessageData, ConverterOptions options, HL7MessageEngine engine) {
        Message hl7message;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)hl7MessageData), (Object)"Input HL7 message cannot be blank");
        if (engine == null) {
            engine = this.getMessageEngine(options);
        }
        if ((hl7message = HL7ToFHIRConverter.getHl7Message(hl7MessageData)) != null) {
            String messageType = HL7DataExtractor.getMessageType(hl7message);
            HL7MessageModel hl7MessageTemplateModel = this.messagetemplates.get(messageType);
            if (hl7MessageTemplateModel != null) {
                return hl7MessageTemplateModel.convert(hl7message, (MessageEngine)engine);
            }
            throw new UnsupportedOperationException("Message type not yet supported " + messageType);
        }
        throw new IllegalArgumentException("Parsed HL7 message was null.");
    }

    private HL7MessageEngine getMessageEngine(ConverterOptions options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"options cannot be null.");
        FHIRContext context = new FHIRContext(options.isPrettyPrint(), options.isValidateResource(), options.getProperties(), options.getZoneIdText());
        return new HL7MessageEngine(context, options.getBundleType());
    }

    private static Message getHl7Message(String data) {
        Message hl7message = null;
        try (InputStream ins = IOUtils.toInputStream((String)data, (Charset)StandardCharsets.UTF_8);){
            Hl7InputStreamMessageStringIterator iterator = new Hl7InputStreamMessageStringIterator(ins);
            if (iterator.hasNext()) {
                hl7message = hparser.getParser().parse(iterator.next());
            }
        }
        catch (HL7Exception e) {
            throw new IllegalArgumentException("Cannot parse the message.", e);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("IOException encountered.", ioe);
        }
        try {
            if (hl7message != null) {
                String[] messageStructureInfoLines;
                String messageStructureInfo = hl7message.printStructure();
                StringBuilder output = new StringBuilder();
                for (String line : messageStructureInfoLines = messageStructureInfo.split(System.getProperty("line.separator"))) {
                    if (!line.contains("|")) {
                        output.append(line);
                    } else {
                        int firstDash = line.indexOf("-");
                        output.append(line.substring(0, firstDash + 5));
                    }
                    output.append("\n");
                }
                if (output.length() > 0) {
                    LOGGER.info("HL7_MESSAGE_STRUCTURE=\n{}", (Object)output);
                }
            }
        }
        catch (HL7Exception e) {
            throw new IllegalArgumentException("Error printing message structure.", e);
        }
        return hl7message;
    }

    private static void close(HL7HapiParser hparser) {
        if (hparser != null) {
            try {
                hparser.getContext().close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failure to close HL7 parser.", e);
            }
        }
    }
}

