/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.data;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Variable;
import ca.uhn.hl7v2.model.primitive.ID;
import ca.uhn.hl7v2.model.primitive.IS;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7DataHandlerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hl7DataHandlerUtil.class);

    private Hl7DataHandlerUtil() {
    }

    public static String getStringValue(Object obj) {
        return Hl7DataHandlerUtil.getStringValue(obj, false);
    }

    public static String getStringValue(Object obj, boolean allComponents) {
        return Hl7DataHandlerUtil.getStringValue(obj, allComponents, ". ", true, true);
    }

    public static String getStringValue(Object obj, boolean allComponents, String separatorString, boolean trim, boolean separatorAtEnd) {
        String returnValue;
        if (obj == null) {
            return null;
        }
        Object local = obj;
        if (local instanceof Collection) {
            List list = (List)local;
            if (list.size() == 1) {
                returnValue = Hl7DataHandlerUtil.toStringValue(list.get(0), allComponents);
            } else if (!list.isEmpty()) {
                int listSize = list.size();
                int listCount = 1;
                StringBuilder sb = new StringBuilder();
                for (Object listItem : list) {
                    sb.append(Hl7DataHandlerUtil.toStringValue(listItem, allComponents));
                    if (separatorAtEnd || listCount < listSize) {
                        sb.append(separatorString);
                    }
                    ++listCount;
                }
                returnValue = sb.toString();
                if (trim) {
                    returnValue = StringUtils.strip((String)returnValue);
                }
            } else {
                returnValue = null;
            }
        } else {
            returnValue = Hl7DataHandlerUtil.toStringValue(local, allComponents);
        }
        return returnValue;
    }

    public static String getTableNumber(Object obj) {
        if (obj instanceof ID) {
            ID id = (ID)obj;
            return "v2-" + StringUtils.leftPad((String)String.valueOf(id.getTable()), (int)4, (char)'0');
        }
        if (obj instanceof IS) {
            IS id = (IS)obj;
            return "v2-" + StringUtils.leftPad((String)String.valueOf(id.getTable()), (int)4, (char)'0');
        }
        if (obj instanceof CWE) {
            CWE id = (CWE)obj;
            return Hl7DataHandlerUtil.getAssociatedtable(id);
        }
        return null;
    }

    public static String getOriginalDisplayText(Object obj) {
        if (obj instanceof CWE) {
            CWE id = (CWE)obj;
            ST st = id.getText();
            if (st != null) {
                String str = st.getValue();
                if (str != null) {
                    return str.trim();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static String getVersion(Object obj) {
        if (obj instanceof CWE) {
            CWE id = (CWE)obj;
            ST st = id.getCodingSystemVersionID();
            if (st != null) {
                String str = st.getValue();
                if (str != null) {
                    return str.trim();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static String getAssociatedtable(CWE id) {
        ca.uhn.hl7v2.model.v26.datatype.ID val = id.getCwe3_NameOfCodingSystem();
        if (val != null && StringUtils.startsWith((CharSequence)val.getValue(), (CharSequence)"HL7")) {
            return "v2-" + StringUtils.leftPad((String)String.valueOf(StringUtils.removeStart((String)val.getValue(), (String)"HL7")), (int)4, (char)'0');
        }
        if (val != null) {
            String returnValue = val.getValue();
            return returnValue != null ? returnValue.trim() : null;
        }
        return null;
    }

    private static String toStringValue(Object local, boolean allComponents) {
        String returnvalue;
        if (local == null) {
            return null;
        }
        if (local instanceof Variable) {
            returnvalue = Hl7DataHandlerUtil.convertVariesDataTypeToString(local, allComponents);
        } else if (local instanceof Composite) {
            Composite com = (Composite)local;
            if (allComponents) {
                returnvalue = Hl7DataHandlerUtil.getValueFromComposite(com);
            } else {
                try {
                    returnvalue = com.getComponent(0).toString();
                }
                catch (DataTypeException e) {
                    LOGGER.warn("Failure when extracting string value");
                    returnvalue = null;
                }
            }
        } else if (local instanceof Primitive) {
            Primitive prem = (Primitive)local;
            returnvalue = prem.getValue();
        } else {
            returnvalue = local.toString();
        }
        return returnvalue;
    }

    private static String convertVariesDataTypeToString(Object obj, boolean allComponents) {
        if (obj instanceof Variable) {
            Variable v = (Variable)obj;
            return Hl7DataHandlerUtil.getStringValue(v.getData(), allComponents);
        }
        return obj.toString();
    }

    private static String getValueFromComposite(Composite com) {
        Type[] types = com.getComponents();
        StringBuilder sb = new StringBuilder();
        for (Type t : types) {
            String text = t.toString();
            if (!StringUtils.isNotBlank((CharSequence)text)) continue;
            sb.append(t.toString()).append(", ");
        }
        return StringUtils.stripEnd((String)sb.toString(), (String)", ");
    }
}

