/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.data;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.segment.PV1;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.hl7.data.Hl7DataHandlerUtil;
import io.github.linuxforhealth.hl7.data.SimpleDataTypeMapper;
import io.github.linuxforhealth.hl7.data.SimpleDataValueResolver;
import io.github.linuxforhealth.hl7.data.ValueExtractor;
import io.github.linuxforhealth.hl7.data.date.DateUtil;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.StringTokenizer;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.codesystems.EncounterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7RelatedGeneralUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hl7RelatedGeneralUtils.class);
    private static final String NOW_FORMAT = "yyyyMMddHHmmss";
    private static final String REGEX_FIRST_TWO_NUMBERS_AMID_OTHER_TEXT = "^\\D*?([\\d.]+)\\D*([\\d.]*).*";
    private static final Pattern PATTERN_FIRST_TWO_NUMBERS_AMID_OTHER_TEXT = Pattern.compile("^\\D*?([\\d.]+)\\D*([\\d.]*).*");

    private Hl7RelatedGeneralUtils() {
    }

    public static Object extractAttribute(Object resource, String path, String klass) {
        if (resource == null) {
            return null;
        }
        Map<String, Object> data = resource;
        if (resource instanceof ResourceValue) {
            ResourceValue rv = (ResourceValue)((Object)resource);
            data = rv.getResource();
        }
        try {
            String json = ObjectMapperUtil.getJSONInstance().writeValueAsString((Object)data);
            List val = (List)JsonPath.parse((String)json).read(path, List.class, new Predicate[0]);
            ValueExtractor<Object, ?> resolver = SimpleDataTypeMapper.getValueResolver(klass);
            return resolver.apply(val);
        }
        catch (JsonProcessingException | RuntimeException e) {
            return null;
        }
    }

    public static String extractLow(Object input) {
        String val = Hl7DataHandlerUtil.getStringValue(input);
        if (StringUtils.isNotBlank((CharSequence)val)) {
            Matcher m = PATTERN_FIRST_TWO_NUMBERS_AMID_OTHER_TEXT.matcher(val);
            if (m.find() && !m.group(2).isEmpty()) {
                return m.group(1);
            }
            return null;
        }
        return null;
    }

    public static String extractHigh(Object input) {
        String val = Hl7DataHandlerUtil.getStringValue(input);
        if (StringUtils.isNotBlank((CharSequence)val)) {
            Matcher m = PATTERN_FIRST_TWO_NUMBERS_AMID_OTHER_TEXT.matcher(val);
            if (m.find()) {
                if (!m.group(2).isEmpty()) {
                    return m.group(2);
                }
                return m.group(1);
            }
            return null;
        }
        return null;
    }

    public static String dateTimeWithZoneId(Object dateTime, Object zoneId) {
        String val = Hl7DataHandlerUtil.getStringValue(dateTime);
        String zoneIdText = Hl7DataHandlerUtil.getStringValue(zoneId);
        if (val != null) {
            return DateUtil.formatToDateTimeWithZone(val, zoneIdText);
        }
        return null;
    }

    public static String getCurrentDateTimeUsingZoneId(Object zoneId) {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(NOW_FORMAT);
        String nowText = now.format(formatter);
        String zoneIdText = Hl7DataHandlerUtil.getStringValue(zoneId);
        String formattedDateTime = DateUtil.formatToDateTimeWithZone(nowText, zoneIdText);
        return formattedDateTime;
    }

    public static String generateResourceId() {
        Instant now = Instant.now();
        BigInteger nano = BigInteger.valueOf(now.getEpochSecond());
        nano = nano.multiply(BigInteger.valueOf(1000000000L));
        nano = nano.add(BigInteger.valueOf(now.getNano()));
        return nano.toString() + "." + UUID.randomUUID().toString();
    }

    public static String pv1DurationLength(Object pv1Value, Object zoneId) {
        if (pv1Value instanceof PV1) {
            String zoneIdText = Hl7DataHandlerUtil.getStringValue(zoneId);
            PV1 pv1 = (PV1)pv1Value;
            DTM start = pv1.getAdmitDateTime();
            DTM end = pv1.getDischargeDateTime();
            try {
                String sdate1 = Hl7DataHandlerUtil.getStringValue(start);
                String sdate2 = Hl7DataHandlerUtil.getStringValue(end);
                if (sdate1 != null && sdate2 != null) {
                    Temporal date1 = DateUtil.getTemporal(DateUtil.formatToDateTimeWithZone(sdate1, zoneIdText));
                    Temporal date2 = DateUtil.getTemporal(DateUtil.formatToDateTimeWithZone(sdate2, zoneIdText));
                    LOGGER.info("computing temporal dates");
                    if (date1 != null && date2 != null) {
                        return String.valueOf(ChronoUnit.MINUTES.between(date1, date2));
                    }
                }
            }
            catch (UnsupportedTemporalTypeException e) {
                LOGGER.warn("Cannot evaluate time difference.");
                return null;
            }
        }
        return null;
    }

    public static String getEncounterStatus(Object var1, Object var2, Object var3) {
        LOGGER.info("Generating encounter status");
        EncounterStatus status = EncounterStatus.UNKNOWN;
        if (var1 != null) {
            status = EncounterStatus.FINISHED;
        } else if (var2 != null) {
            status = EncounterStatus.ARRIVED;
        } else if (var3 != null) {
            status = EncounterStatus.CANCELLED;
        }
        return status.toCode();
    }

    public static String getImmunizationStatus(Object rxa18, Object rxa20, Object orc5) {
        if (rxa20 != null) {
            return SimpleDataValueResolver.getFHIRCode(rxa20.toString(), Immunization.ImmunizationStatus.class);
        }
        if (rxa18 != null) {
            return "not-done";
        }
        if (orc5 != null) {
            return SimpleDataValueResolver.getFHIRCode(orc5.toString(), Immunization.ImmunizationStatus.class);
        }
        return "completed";
    }

    public static String getDocumentReferenceStatus(Object txa, Object txa19, Object orc, Object obr25, Object obx2) {
        LOGGER.info("Generating DocumentReference status");
        if (txa != null || orc != null && Objects.equals(Hl7DataHandlerUtil.getStringValue(obx2), "TX")) {
            String code;
            String val = Hl7DataHandlerUtil.getStringValue(txa19);
            if (val == null) {
                val = Hl7DataHandlerUtil.getStringValue(obr25);
            }
            if ((code = SimpleDataValueResolver.getFHIRCode(val, Enumerations.DocumentReferenceStatus.class)) != null) {
                return code;
            }
            return "current";
        }
        return null;
    }

    public static String generateName(Object prefix, Object first, Object middle, Object family, Object suffix) {
        String name;
        LOGGER.info("Generating name");
        StringBuilder sb = new StringBuilder();
        String valprefix = Hl7DataHandlerUtil.getStringValue(prefix);
        String valfirst = Hl7DataHandlerUtil.getStringValue(first);
        String valmiddle = Hl7DataHandlerUtil.getStringValue(middle);
        String valfamily = Hl7DataHandlerUtil.getStringValue(family);
        String valsuffix = Hl7DataHandlerUtil.getStringValue(suffix);
        if (valprefix != null) {
            sb.append(valprefix).append(" ");
        }
        if (valfirst != null) {
            sb.append(valfirst).append(" ");
        }
        if (valmiddle != null) {
            sb.append(valmiddle).append(" ");
        }
        if (valfamily != null) {
            sb.append(valfamily).append(" ");
        }
        if (valsuffix != null) {
            sb.append(valsuffix).append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)(name = sb.toString()))) {
            return name.trim();
        }
        return null;
    }

    public static Long diffDateMin(Object start, Object end) {
        LOGGER.info("Generating time diff");
        try {
            Temporal date1 = DateUtil.getTemporal(Hl7DataHandlerUtil.getStringValue(start));
            Temporal date2 = DateUtil.getTemporal(Hl7DataHandlerUtil.getStringValue(end));
            LOGGER.info("computing temporal dates");
            if (date1 != null && date2 != null) {
                return ChronoUnit.MINUTES.between(date1, date2);
            }
        }
        catch (UnsupportedTemporalTypeException e) {
            LOGGER.warn("Cannot evaluate time difference.");
            return null;
        }
        return null;
    }

    public static String split(Object input, String delimitter, int index) {
        StringTokenizer stk;
        String stringRepVal = Hl7DataHandlerUtil.getStringValue(input);
        if (StringUtils.isNotBlank((CharSequence)stringRepVal) && (stk = new StringTokenizer(stringRepVal, delimitter)).getTokenList().size() > index) {
            return (String)stk.getTokenList().get(index);
        }
        return null;
    }

    public static String noWhiteSpace(Object input) {
        String val = Hl7DataHandlerUtil.getStringValue(input);
        if (val != null) {
            String newVal = val.replaceAll("\\s", "_");
            return "urn:id:" + newVal;
        }
        return null;
    }

    public static String concatenateWithChar(Object input, String delimiterChar) {
        String delimiter = delimiterChar.replaceAll("(?<!\\\\)\\\\n|\\n", "\n");
        return Hl7DataHandlerUtil.getStringValue(input, true, delimiter, false, false);
    }

    public static List<String> makeStringArray(String ... strs) {
        ArrayList<String> result = new ArrayList<String>();
        for (String str : strs) {
            if (str == null) continue;
            result.add(str);
        }
        return result;
    }

    public static String getAddressUse(String xad7Type, String xad16Temp, String xad17Bad) {
        LOGGER.info("Calculating Address Use");
        String addressUse = "";
        if (xad16Temp != null && xad16Temp.equalsIgnoreCase("Y") || (xad16Temp == null || xad16Temp.isEmpty()) && xad7Type != null && xad7Type.equalsIgnoreCase("C")) {
            addressUse = "temp";
        } else if (xad17Bad != null && xad17Bad.equalsIgnoreCase("Y") || (xad17Bad == null || xad17Bad.isEmpty()) && xad7Type != null && xad7Type.equalsIgnoreCase("BA")) {
            addressUse = "old";
        } else if (xad7Type != null && xad7Type.equalsIgnoreCase("H")) {
            addressUse = "home";
        } else if (xad7Type != null && (xad7Type.equalsIgnoreCase("B") || xad7Type.equalsIgnoreCase("O"))) {
            addressUse = "work";
        } else if (xad7Type != null && xad7Type.equalsIgnoreCase("BI")) {
            addressUse = "billing";
        }
        return addressUse;
    }

    public static String getAddressType(String xad7Type, String xad18Type) {
        LOGGER.info("Calculating Address Type");
        String addressType = "";
        if (xad18Type != null && xad18Type.equalsIgnoreCase("M") || (xad18Type == null || xad18Type.isEmpty()) && xad7Type != null && xad7Type.equalsIgnoreCase("M")) {
            addressType = "postal";
        } else if (xad18Type != null && xad18Type.equalsIgnoreCase("V") || (xad18Type == null || xad18Type.isEmpty()) && xad7Type != null && xad7Type.equalsIgnoreCase("SH")) {
            addressType = "physical";
        }
        return addressType;
    }

    public static String getAddressDistrict(String patientCountyPid12, String addressCountyParishPid119, Object patient) {
        LOGGER.info("Calculating AddressCountyParish");
        String returnDistrict = addressCountyParishPid119;
        if (returnDistrict == null) {
            Segment pidSegment = (Segment)patient;
            try {
                Type[] addresses = pidSegment.getField(11);
                if (addresses.length == 1) {
                    returnDistrict = patientCountyPid12;
                }
            }
            catch (HL7Exception hL7Exception) {
                // empty catch block
            }
        }
        return returnDistrict;
    }

    public static String getFormattedTelecomNumberValue(String xtn1Old, String xtn5Country, String xtn6Area, String xtn7Local, String xtn8Extension, String xtn12Unformatted) {
        Object returnValue = "";
        if (xtn7Local != null && xtn7Local.length() > 0) {
            returnValue = Hl7RelatedGeneralUtils.formatCountryAndArea(xtn5Country, xtn6Area) + Hl7RelatedGeneralUtils.formatLocalNumber(xtn7Local);
            if (xtn8Extension != null && xtn8Extension.length() > 0) {
                returnValue = (String)returnValue + " ext. " + xtn8Extension;
            }
        } else if (xtn12Unformatted != null && xtn12Unformatted.length() > 0) {
            returnValue = xtn12Unformatted;
        } else if (xtn1Old != null && xtn1Old.length() > 0) {
            returnValue = xtn1Old;
        }
        return returnValue;
    }

    public static String getNarrativeDiv(String text) {
        String divText = "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>%s</p></div>";
        return String.format(divText, StringEscapeUtils.escapeHtml4((String)text).replace("~", "<br />"));
    }

    private static String formatLocalNumber(String localNumber) {
        return localNumber.substring(0, 3) + " " + localNumber.substring(3);
    }

    private static String formatCountryAndArea(String country, String area) {
        Object returnValue = "";
        if (area != null && area.length() > 0) {
            returnValue = country != null && country.length() > 0 ? "+" + country + " " + area + " " : "(" + area + ") ";
        }
        return returnValue;
    }
}

