/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.data;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v26.datatype.CE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DT;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.PPN;
import ca.uhn.hl7v2.model.v26.datatype.TS;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.group.VXU_V04_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.VXU_V04_ORDER;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.core.terminology.Hl7v2Mapping;
import io.github.linuxforhealth.core.terminology.SimpleCode;
import io.github.linuxforhealth.core.terminology.TerminologyLookup;
import io.github.linuxforhealth.core.terminology.UrlLookup;
import io.github.linuxforhealth.hl7.data.Hl7DataHandlerUtil;
import io.github.linuxforhealth.hl7.data.ValueExtractor;
import io.github.linuxforhealth.hl7.data.date.DateUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hl7.fhir.dstu3.model.codesystems.MedicationRequestCategory;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r4.model.codesystems.CompositionStatus;
import org.hl7.fhir.r4.model.codesystems.ConditionCategory;
import org.hl7.fhir.r4.model.codesystems.ConditionClinical;
import org.hl7.fhir.r4.model.codesystems.ConditionVerStatus;
import org.hl7.fhir.r4.model.codesystems.DiagnosisRole;
import org.hl7.fhir.r4.model.codesystems.MessageReasonEncounter;
import org.hl7.fhir.r4.model.codesystems.NameUse;
import org.hl7.fhir.r4.model.codesystems.SubscriberRelationship;
import org.hl7.fhir.r4.model.codesystems.V3ActCode;
import org.hl7.fhir.r4.model.codesystems.V3MaritalStatus;
import org.hl7.fhir.r4.model.codesystems.V3ReligiousAffiliation;
import org.hl7.fhir.r4.model.codesystems.V3RoleCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDataValueResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDataValueResolver.class);
    private static final String INVALID_CODE_MESSAGE_FULL = "Invalid input: code '%s' could not be mapped to values in system '%s' with original display '%s' and version '%s'.";
    private static final String INVALID_CODE_MESSAGE_SHORT = "Invalid input: code '%s' could not be mapped to values in system '%s'.";
    public static final ValueExtractor<Object, String> DATE = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val != null) {
            return DateUtil.formatToDate(val);
        }
        return null;
    };
    public static final ValueExtractor<Object, String> STRING = value -> Hl7DataHandlerUtil.getStringValue(value);
    public static final ValueExtractor<Object, String> STRING_ALL = value -> Hl7DataHandlerUtil.getStringValue(value, true);
    public static final ValueExtractor<Object, String> VALID_ID = value -> {
        String strValue = Hl7DataHandlerUtil.getStringValue(value);
        if (strValue != null) {
            strValue = strValue.toLowerCase();
            return strValue.replaceAll("[^a-zA-Z0-9.]", "-");
        }
        return null;
    };
    public static final ValueExtractor<Object, String> CLEAN_SSN = value -> {
        String strValue = Hl7DataHandlerUtil.getStringValue(value);
        if (strValue != null) {
            return strValue.replaceAll("\\-", "");
        }
        return null;
    };
    public static final ValueExtractor<Object, URI> URI_VAL = value -> {
        try {
            String val = Hl7DataHandlerUtil.getStringValue(value);
            if (val != null && SimpleDataValueResolver.isValidUUID(val)) {
                return new URI("urn", "uuid", val);
            }
            return null;
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            LOGGER.warn("Value not valid URI, value: {}", value);
            return null;
        }
    };
    public static final ValueExtractor<Object, String> PERSON_DISPLAY_NAME = value -> {
        String name;
        StringBuilder sb = new StringBuilder();
        String valprefix = null;
        String valfirst = null;
        String valmiddle = null;
        String valfamily = null;
        String valsuffix = null;
        if (value instanceof XCN) {
            XCN xcn = (XCN)value;
            valprefix = Hl7DataHandlerUtil.getStringValue(xcn.getPrefixEgDR());
            valfirst = Hl7DataHandlerUtil.getStringValue(xcn.getGivenName());
            valmiddle = Hl7DataHandlerUtil.getStringValue(xcn.getSecondAndFurtherGivenNamesOrInitialsThereof());
            valfamily = Hl7DataHandlerUtil.getStringValue(xcn.getFamilyName());
            valsuffix = Hl7DataHandlerUtil.getStringValue(xcn.getSuffixEgJRorIII());
        } else if (value instanceof PPN) {
            PPN ppn = (PPN)value;
            valprefix = Hl7DataHandlerUtil.getStringValue(ppn.getPrefixEgDR());
            valfirst = Hl7DataHandlerUtil.getStringValue(ppn.getGivenName());
            valmiddle = Hl7DataHandlerUtil.getStringValue(ppn.getSecondAndFurtherGivenNamesOrInitialsThereof());
            valfamily = Hl7DataHandlerUtil.getStringValue(ppn.getFamilyName());
            valsuffix = Hl7DataHandlerUtil.getStringValue(ppn.getSuffixEgJRorIII());
        }
        if (valprefix != null) {
            sb.append(valprefix).append(" ");
        }
        if (valfirst != null) {
            sb.append(valfirst).append(" ");
        }
        if (valmiddle != null) {
            sb.append(valmiddle).append(" ");
        }
        if (valfamily != null) {
            sb.append(valfamily).append(" ");
        }
        if (valsuffix != null) {
            sb.append(valsuffix).append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)(name = sb.toString()))) {
            return name.trim();
        }
        return null;
    };
    public static final ValueExtractor<Object, String> ADMINISTRATIVE_GENDER_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, Enumerations.AdministrativeGender.class);
        if (code != null) {
            return code;
        }
        if (val == null) {
            return null;
        }
        return Enumerations.AdministrativeGender.UNKNOWN.toCode();
    };
    public static final ValueExtractor<Object, String> MEDREQ_STATUS_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, MedicationRequest.MedicationRequestStatus.class);
        if (code != null) {
            return code;
        }
        return "unknown";
    };
    public static final ValueExtractor<Object, SimpleCode> MEDREQ_CATEGORY_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, MedicationRequestCategory.class);
        if (code != null) {
            MedicationRequestCategory category = MedicationRequestCategory.fromCode((String)code);
            return new SimpleCode(code, "http://terminology.hl7.org/CodeSystem/medicationrequest-category", category.getDisplay());
        }
        return null;
    };
    public static final ValueExtractor<Object, String> OBSERVATION_STATUS_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getFHIRCode(val, Observation.ObservationStatus.class);
    };
    public static final ValueExtractor<Object, String> FIND_EDUCATION_REFERENCE_TEXT = value -> SimpleDataValueResolver.getSelectedSiblingObservationTEXTfromObxGroup(value, "30956-7");
    public static final ValueExtractor<Object, String> FIND_EDUCATION_DOCUMENT_TYPE_TEXT = value -> SimpleDataValueResolver.getSelectedSiblingObservationTEXTfromObxGroup(value, "69764-9");
    public static final ValueExtractor<Object, String> FIND_EDUCATION_PUBLICATION_DATE = value -> SimpleDataValueResolver.getSelectedSiblingObservationDATEfromObxGroup(value, "29768-9");
    public static final ValueExtractor<Object, String> FIND_EDUCATION_PRESENTATION_DATE = value -> SimpleDataValueResolver.getSelectedSiblingObservationDATEfromObxGroup(value, "29769-7");
    public static final ValueExtractor<Object, SimpleCode> OBSERVATION_STATUS_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, Observation.ObservationStatus.class);
        if (code != null) {
            Observation.ObservationStatus status = Observation.ObservationStatus.fromCode((String)code);
            return new SimpleCode(code, status.getSystem(), status.getDisplay());
        }
        String theSystem = Observation.ObservationStatus.REGISTERED.getSystem();
        return new SimpleCode(null, theSystem, String.format(INVALID_CODE_MESSAGE_SHORT, val, theSystem));
    };
    public static final ValueExtractor<Object, String> SERVICE_REQUEST_STATUS = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getFHIRCode(val, ServiceRequest.ServiceRequestStatus.class);
    };
    public static final ValueExtractor<Object, SimpleCode> CONDITION_CATEGORY_CODES = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val != null) {
            ConditionCategory status = ConditionCategory.fromCode((String)val);
            return new SimpleCode(val, status.getSystem(), status.getDisplay());
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> RELIGIOUS_AFFILIATION_FHIR_CC = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, V3ReligiousAffiliation.class);
        String text = Hl7DataHandlerUtil.getOriginalDisplayText(value);
        String version = Hl7DataHandlerUtil.getVersion(value);
        if (code != null) {
            V3ReligiousAffiliation status = V3ReligiousAffiliation.fromCode((String)code);
            return new SimpleCode(code, status.getSystem(), status.getDisplay());
        }
        String religionSystem = V3ReligiousAffiliation._1028.getSystem();
        return new SimpleCode(null, religionSystem, String.format(INVALID_CODE_MESSAGE_FULL, val, religionSystem, text, version));
    };
    public static final ValueExtractor<Object, SimpleCode> DIAGNOSIS_USE = value -> {
        SimpleCode coding;
        String table;
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val != null && (val.equals("F") || val.equals("W")) && (table = Hl7DataHandlerUtil.getTableNumber(value)) != null && val != null && (coding = TerminologyLookup.lookup(table, val)) != null && coding.getDisplay() != null && !coding.getDisplay().isEmpty()) {
            return coding;
        }
        String code = SimpleDataValueResolver.getFHIRCode(val, DiagnosisRole.class);
        if (code != null) {
            DiagnosisRole use = DiagnosisRole.fromCode((String)code);
            return new SimpleCode(code, use.getSystem(), use.getDisplay());
        }
        return new SimpleCode(val, null, null);
    };
    public static final ValueExtractor<Object, SimpleCode> CONDITION_CLINICAL_STATUS_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        ConditionClinical use = null;
        try {
            use = ConditionClinical.fromCode((String)val);
            LOGGER.info("Found ConditionClinical code for '{}'.", (Object)val);
        }
        catch (FHIRException e) {
            LOGGER.warn("Could not find ConditionClinical code for '{}'.", (Object)val);
        }
        if (use != null) {
            return new SimpleCode(val, use.getSystem(), use.getDisplay());
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> CONDITION_VERIFICATION_STATUS_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        ConditionVerStatus use = null;
        try {
            use = ConditionVerStatus.fromCode((String)val);
            LOGGER.info("Found ConditionVerStatus code for '{}'.", (Object)val);
        }
        catch (FHIRException e) {
            LOGGER.warn("Could not find ConditionVerStatus code for '{}'.", (Object)val);
        }
        if (use != null) {
            return new SimpleCode(val, use.getSystem(), use.getDisplay());
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> ACT_ENCOUNTER_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, V3ActCode.class);
        String version = Hl7DataHandlerUtil.getVersion(value);
        if (code != null) {
            V3ActCode act = V3ActCode.fromCode((String)code);
            return new SimpleCode(code, act.getSystem(), act.getDisplay(), version);
        }
        if (val != null) {
            return new SimpleCode(val, null, null);
        }
        return null;
    };
    public static final ValueExtractor<Object, String> SPECIMEN_STATUS_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getFHIRCode(val, Specimen.SpecimenStatus.class);
    };
    public static final ValueExtractor<Object, String> DOC_REF_DOC_STATUS_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getFHIRCode(val, CompositionStatus.class);
    };
    public static final ValueExtractor<Object, String> NAME_USE_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getFHIRCode(val, NameUse.class);
    };
    public static final ValueExtractor<Object, String> ENCOUNTER_MODE_ARRIVAL_DISPLAY = value -> SimpleDataValueResolver.getFHIRCode(Hl7DataHandlerUtil.getStringValue(value), "EncounterModeOfArrivalDisplay");
    public static final ValueExtractor<Object, SimpleCode> POLICYHOLDER_RELATIONSHIP_IN117 = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, "PolicyholderRelationshipIN117");
        String version = Hl7DataHandlerUtil.getVersion(value);
        if (code != null) {
            V3RoleCode relationship = V3RoleCode.fromCode((String)code);
            return new SimpleCode(code, relationship.getSystem(), relationship.getDisplay(), version);
        }
        return new SimpleCode(val, null, null, null);
    };
    public static final ValueExtractor<Object, SimpleCode> POLICYHOLDER_RELATIONSHIP_IN272 = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, "PolicyholderRelationshipIN272");
        String version = Hl7DataHandlerUtil.getVersion(value);
        if (code != null) {
            V3RoleCode relationship = V3RoleCode.fromCode((String)code);
            return new SimpleCode(code, relationship.getSystem(), relationship.getDisplay(), version);
        }
        return new SimpleCode(val, null, null, null);
    };
    public static final ValueExtractor<Object, SimpleCode> SUBSCRIBER_RELATIONSHIP_IN117 = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, "SubscriberRelationshipIN117");
        String version = Hl7DataHandlerUtil.getVersion(value);
        if (code != null) {
            SubscriberRelationship relationship = SubscriberRelationship.fromCode((String)code);
            return new SimpleCode(code, relationship.getSystem(), relationship.getDisplay(), version);
        }
        return new SimpleCode(val, null, null, null);
    };
    public static final ValueExtractor<Object, SimpleCode> SUBSCRIBER_RELATIONSHIP_IN272 = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, "SubscriberRelationshipIN272");
        String version = Hl7DataHandlerUtil.getVersion(value);
        if (code != null) {
            SubscriberRelationship relationship = SubscriberRelationship.fromCode((String)code);
            return new SimpleCode(code, relationship.getSystem(), relationship.getDisplay(), version);
        }
        return new SimpleCode(val, null, null, null);
    };
    public static final ValueExtractor<Object, String> RELATED_PERSON_NEEDED_IN117 = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getFHIRCode(val, "RelatedPersonNeededIN117");
    };
    public static final ValueExtractor<Object, String> RELATED_PERSON_NEEDED_IN272 = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getFHIRCode(val, "RelatedPersonNeededIN272");
    };
    public static final ValueExtractor<Object, SimpleCode> MARITAL_STATUS = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String text = Hl7DataHandlerUtil.getOriginalDisplayText(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, V3MaritalStatus.class);
        String version = Hl7DataHandlerUtil.getVersion(value);
        if (code != null) {
            V3MaritalStatus mar = V3MaritalStatus.fromCode((String)code);
            return new SimpleCode(code, mar.getSystem(), mar.getDisplay(), version);
        }
        String theSystem = V3MaritalStatus.M.getSystem();
        return new SimpleCode(null, theSystem, String.format(INVALID_CODE_MESSAGE_FULL, val, theSystem, text, version));
    };
    public static final ValueExtractor<Object, Boolean> BOOLEAN = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (null == val) {
            return false;
        }
        return BooleanUtils.toBoolean((String)val);
    };
    public static final ValueExtractor<Object, Integer> INTEGER = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (null == val) {
            return null;
        }
        if (NumberUtils.isCreatable((String)val)) {
            return NumberUtils.createInteger((String)val);
        }
        LOGGER.warn("Value {} for INTEGER is not a valid number so returning null.", value);
        return null;
    };
    public static final ValueExtractor<Object, Float> FLOAT = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (null == val) {
            return null;
        }
        if (NumberUtils.isCreatable((String)val)) {
            return NumberUtils.createFloat((String)val);
        }
        LOGGER.warn("Value {} for DECIMAL is not a valid number so returning null.", value);
        return null;
    };
    public static final ValueExtractor<Object, UUID> UUID_VAL = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getUUID(val);
    };
    public static final ValueExtractor<Object, String> BASE64_BINARY = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return Base64.getEncoder().encodeToString(val.getBytes());
    };
    public static final ValueExtractor<Object, Object> OBJECT = value -> value;
    public static final ValueExtractor<Object, SimpleCode> CODING_SYSTEM_V2_IDENTIFIER = value -> {
        SimpleCode coding;
        value = SimpleDataValueResolver.checkForAndUnwrapVariesObject(value);
        String table = Hl7DataHandlerUtil.getTableNumber(value);
        String code = Hl7DataHandlerUtil.getStringValue(value);
        if (table != null && code != null && (coding = TerminologyLookup.lookup(table, code)) != null && coding.getDisplay() != null && !coding.getDisplay().isEmpty()) {
            return coding;
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> CODING_SYSTEM_V2_IS_USER_DEFINED_TABLE = value -> {
        value = SimpleDataValueResolver.checkForAndUnwrapVariesObject(value);
        String table = Hl7DataHandlerUtil.getTableNumber(value);
        String code = Hl7DataHandlerUtil.getStringValue(value);
        if (table != null && code != null) {
            SimpleCode coding = TerminologyLookup.lookup(table, code);
            if (coding != null && coding.getDisplay() != null && !coding.getDisplay().isEmpty()) {
                return coding;
            }
            return new SimpleCode(code, null, null, null);
        }
        if (table == null && code != null) {
            return new SimpleCode(code, null, null, null);
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> CODING_SYSTEM_V2_ALTERNATE = value -> {
        if ((value = SimpleDataValueResolver.checkForAndUnwrapVariesObject(value)) instanceof CWE) {
            CWE cwe = (CWE)value;
            String table = Hl7DataHandlerUtil.getStringValue(cwe.getCwe6_NameOfAlternateCodingSystem());
            String code = Hl7DataHandlerUtil.getStringValue(cwe.getCwe4_AlternateIdentifier());
            String text = Hl7DataHandlerUtil.getStringValue(cwe.getCwe5_AlternateText());
            String version = Hl7DataHandlerUtil.getStringValue(cwe.getCwe8_AlternateCodingSystemVersionID());
            return SimpleDataValueResolver.commonCodingSystemV2(table, code, text, version);
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> CODING_SYSTEM_V2 = value -> {
        value = SimpleDataValueResolver.checkForAndUnwrapVariesObject(value);
        String table = Hl7DataHandlerUtil.getTableNumber(value);
        String code = Hl7DataHandlerUtil.getStringValue(value);
        String text = Hl7DataHandlerUtil.getOriginalDisplayText(value);
        String version = Hl7DataHandlerUtil.getVersion(value);
        return SimpleDataValueResolver.commonCodingSystemV2(table, code, text, version);
    };
    public static final ValueExtractor<Object, String> UNIT_SYSTEM = value -> {
        String version;
        String text;
        String code;
        String table = Hl7DataHandlerUtil.getTableNumber(value = SimpleDataValueResolver.checkForAndUnwrapVariesObject(value));
        SimpleCode codingSystem = SimpleDataValueResolver.commonCodingSystemV2(table, code = Hl7DataHandlerUtil.getStringValue(value), text = Hl7DataHandlerUtil.getOriginalDisplayText(value), version = Hl7DataHandlerUtil.getVersion(value));
        if (codingSystem.getSystem() != null) {
            return codingSystem.getSystem();
        }
        return "http://unitsofmeasure.org";
    };
    public static final ValueExtractor<Object, String> BUILD_IDENTIFIER_FROM_CWE = value -> {
        Varies variesValue;
        if (value instanceof Varies && (variesValue = (Varies)value).getData() instanceof CWE) {
            value = (CWE)variesValue.getData();
        }
        if (value instanceof CWE) {
            CWE newValue = (CWE)value;
            String identifier = newValue.getCwe1_Identifier().toString();
            String text = newValue.getCwe2_Text().toString();
            String codingSystem = newValue.getCwe3_NameOfCodingSystem().toString();
            if (identifier != null) {
                if (codingSystem != null) {
                    String join = identifier + "-" + codingSystem;
                    return join;
                }
                return identifier;
            }
            return text;
        }
        return null;
    };
    public static final ValueExtractor<Object, String> ALLERGY_INTOLERANCE_CRITICALITY_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, AllergyIntolerance.AllergyIntoleranceCriticality.class);
        if (code != null) {
            return code;
        }
        return null;
    };
    public static final ValueExtractor<Object, String> ALLERGY_INTOLERANCE_CATEGORY_CODE_FHIR = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return SimpleDataValueResolver.getFHIRCode(val, AllergyIntolerance.AllergyIntoleranceCategory.class);
    };
    public static final ValueExtractor<Object, String> DOSE_VALUE = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val.startsWith("999")) {
            return null;
        }
        return val;
    };
    public static final ValueExtractor<Object, String> DOSE_SYSTEM = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String url = UrlLookup.getAssociatedUrl(val);
        if (url != null) {
            return url;
        }
        if (val != null && val.length() > 0) {
            return "urn:id:" + val.replace(" ", "_");
        }
        return null;
    };
    public static final ValueExtractor<Object, String> SYSTEM_URL = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        return UrlLookup.getAssociatedUrl(val);
    };
    public static final ValueExtractor<Object, String> SYSTEM_ID = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (val != null && val.length() > 0) {
            return "urn:id:" + val.replace(" ", "_");
        }
        return null;
    };
    public static final ValueExtractor<Object, List<?>> ARRAY = value -> {
        if (value != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            return list;
        }
        return null;
    };
    public static final ValueExtractor<Object, String> RELATIVE_REFERENCE = value -> {
        Map<String, Object> mapValue = null;
        if (value instanceof Map) {
            mapValue = (Map<String, Object>)value;
        } else if (value instanceof ResourceValue) {
            ResourceValue rv = (ResourceValue)value;
            mapValue = rv.getResource();
        }
        if (mapValue != null) {
            String type = Hl7DataHandlerUtil.getStringValue(mapValue.get("resourceType"));
            String refId = Hl7DataHandlerUtil.getStringValue(mapValue.get("id"));
            if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)refId)) {
                return type + "/" + refId;
            }
        }
        return null;
    };
    public static final ValueExtractor<Object, String> DIAGNOSTIC_REPORT_STATUS_CODES = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, DiagnosticReport.DiagnosticReportStatus.class);
        if (code != null) {
            return code;
        }
        return DiagnosticReport.DiagnosticReportStatus.UNKNOWN.toCode();
    };
    public static final ValueExtractor<Object, UUID> NAMED_UUID = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        if (StringUtils.isNotBlank((CharSequence)val)) {
            return UUID.nameUUIDFromBytes(val.getBytes());
        }
        return null;
    };
    public static final ValueExtractor<Object, SimpleCode> MESSAGE_REASON_ENCOUNTER = value -> {
        String val = Hl7DataHandlerUtil.getStringValue(value);
        String code = SimpleDataValueResolver.getFHIRCode(val, MessageReasonEncounter.class);
        if (code != null) {
            MessageReasonEncounter en = MessageReasonEncounter.fromCode((String)code);
            return new SimpleCode(code, en.getSystem(), en.getDisplay());
        }
        String theSystem = MessageReasonEncounter.ADMIT.getSystem();
        return new SimpleCode(null, theSystem, String.format(INVALID_CODE_MESSAGE_SHORT, val, theSystem));
    };
    public static final ValueExtractor<Object, String> PATIENT_INSTRUCTION = value -> {
        if (value instanceof CWE) {
            CWE cwe = (CWE)value;
            String cwe1 = cwe.getCwe1_Identifier().toString();
            String cwe2 = cwe.getCwe2_Text().toString();
            if (cwe1 != null) {
                if (cwe2 != null) {
                    return cwe1 + ":" + cwe2;
                }
            } else if (cwe1 == null) {
                return cwe2;
            }
        }
        return null;
    };

    private static final String getSelectedSiblingObservationTEXTfromObxGroup(Object valueObx, String siblingCode) {
        Object obj = SimpleDataValueResolver.getSelectedSiblingObservationVALUEfromObxGroup(valueObx, siblingCode);
        if (obj != null) {
            String returnVal = null;
            if (obj instanceof CE) {
                returnVal = Hl7DataHandlerUtil.getStringValue(((CE)obj).getText());
            }
            if (obj instanceof CWE) {
                returnVal = Hl7DataHandlerUtil.getStringValue(((CWE)obj).getText());
            }
            return returnVal != null ? returnVal : "unspecified";
        }
        return null;
    }

    private static final String getSelectedSiblingObservationDATEfromObxGroup(Object valueObx, String siblingCode) {
        Object obj = SimpleDataValueResolver.getSelectedSiblingObservationVALUEfromObxGroup(valueObx, siblingCode);
        if (obj instanceof DT) {
            return DateUtil.formatToDate(((DT)obj).getValue());
        }
        if (obj instanceof TS) {
            return DateUtil.formatToDate(((TS)obj).getTime().toString());
        }
        if (obj instanceof DTM) {
            String dateString = ((DTM)obj).getValue();
            return dateString.length() > 7 ? DateUtil.formatToDate(dateString.substring(0, 8)) : null;
        }
        return null;
    }

    private static final Object getSelectedSiblingObservationVALUEfromObxGroup(Object valueObx, String siblingCode) {
        if (valueObx instanceof OBX) {
            try {
                OBX obx = (OBX)valueObx;
                String obx4GroupNum = obx.getObx4_ObservationSubID().getValueOrEmpty();
                VXU_V04_OBSERVATION containingObservation = (VXU_V04_OBSERVATION)obx.getParent();
                VXU_V04_ORDER containingOrder = (VXU_V04_ORDER)containingObservation.getParent();
                List observations = containingOrder.getOBSERVATIONAll();
                for (VXU_V04_OBSERVATION obsIter : observations) {
                    OBX obsIterObx = obsIter.getOBX();
                    if (!obx4GroupNum.equals(obsIterObx.getObx4_ObservationSubID().getValueOrEmpty()) || !obsIterObx.getObx3_ObservationIdentifier().getCwe1_Identifier().getValueOrEmpty().equals(siblingCode)) continue;
                    if (obsIterObx.getObservationValueReps() > 0) {
                        return obsIterObx.getObservationValue(0).getData();
                    }
                    return null;
                }
            }
            catch (HL7Exception e) {
                return null;
            }
        }
        return null;
    }

    private static final Object checkForAndUnwrapVariesObject(Object value) {
        if (value instanceof Varies) {
            Varies v = (Varies)value;
            value = v.getData();
        }
        return value;
    }

    private static final SimpleCode commonCodingSystemV2(String table, String code, String text, String version) {
        if (table != null && code != null) {
            SimpleCode coding = TerminologyLookup.lookup(table, code);
            if (coding != null) {
                String display = coding.getDisplay();
                if (display != null) {
                    if (display.isEmpty()) {
                        coding = new SimpleCode(coding.getCode(), coding.getSystem(), text, version);
                    }
                    coding.setVersion(version);
                    return coding;
                }
                return new SimpleCode(null, coding.getSystem(), String.format(INVALID_CODE_MESSAGE_FULL, code, coding.getSystem(), text, version));
            }
            return new SimpleCode(code, "urn:id:" + table, text, version);
        }
        if (code != null) {
            return new SimpleCode(code, null, text);
        }
        return null;
    }

    private SimpleDataValueResolver() {
    }

    private static UUID getUUID(String value) {
        if (value != null) {
            try {
                return UUID.fromString(value);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Value not valid UUID");
                return null;
            }
        }
        LOGGER.info("Value for UUID is null");
        return null;
    }

    private static boolean isValidUUID(String val) {
        try {
            UUID.fromString(val);
            return true;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Could not extract valid UUID - not a valid UUID");
            return false;
        }
    }

    public static String getFHIRCode(String hl7Value, Class<?> fhirConceptClassName) {
        return SimpleDataValueResolver.getFHIRCode(hl7Value, fhirConceptClassName.getSimpleName());
    }

    public static String getFHIRCode(String hl7Value, String fhirMappingConceptName) {
        if (hl7Value != null) {
            Map<String, String> mapping = Hl7v2Mapping.getMapping(fhirMappingConceptName);
            if (mapping != null && !mapping.isEmpty()) {
                return mapping.get(StringUtils.upperCase((String)hl7Value, (Locale)Locale.ENGLISH));
            }
            return null;
        }
        return null;
    }
}

