/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.data.date;

import io.github.linuxforhealth.core.config.ConverterConfiguration;
import io.github.linuxforhealth.hl7.data.date.DateFormats;
import java.lang.invoke.CallSite;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);

    private DateUtil() {
    }

    public static String formatToDate(String input) {
        DateTimeFormatter format = null;
        for (Map.Entry<Pattern, DateTimeFormatter> pattern : DateFormats.getDatePatternsInstance().entrySet()) {
            if (!pattern.getKey().matcher(input).matches()) continue;
            format = pattern.getValue();
            break;
        }
        try {
            LocalDate ldt = LocalDate.parse(input, DateFormats.getFormatterInstance());
            return ldt.format(format);
        }
        catch (DateTimeParseException e) {
            LOGGER.warn("Input value cannot be formatted to LocalDate.");
            return null;
        }
    }

    public static String formatToDateTimeWithDefaultZone(String input) {
        return DateUtil.formatToDateTimeWithZone(input, null);
    }

    public static String formatToDateTimeWithZone(String input, String zoneId) {
        String returnValue = DateUtil.getLocalDate(input);
        if (returnValue == null) {
            returnValue = DateUtil.getZonedDate(input);
        }
        if (returnValue == null) {
            returnValue = DateUtil.getLocalDateTimeWithZone(input, zoneId);
        }
        return returnValue;
    }

    private static String getLocalDateTimeWithZone(String input, String zoneIdText) {
        try {
            ZoneId zone;
            LocalDateTime ldt = LocalDateTime.parse(input, DateFormats.getFormatterInstance());
            ZoneId zoneId = zone = zoneIdText != null ? DateUtil.getZoneIdFromText(zoneIdText) : null;
            if (zoneIdText != null && !zoneIdText.isEmpty() && zone == null) {
                LOGGER.warn("Input zoneId not recognized.  Using default Zone.");
            }
            if (zone == null) {
                zone = ConverterConfiguration.getInstance().getZoneId();
            }
            if (zone == null) {
                zone = DateUtil.getZoneIdFromText(TimeZone.getDefault().getID());
            }
            if (zone != null) {
                return ldt.atZone(zone).format(DateFormats.FHIR_ZONE_DATE_TIME_FORMAT);
            }
            LOGGER.warn("No default zone set, cannot convert LocalDateTime to ZonedDateTime");
            return null;
        }
        catch (DateTimeParseException e) {
            LOGGER.warn("Date parsing failure for value.");
            return null;
        }
    }

    private static ZoneId getZoneIdFromText(String zoneIdText) {
        try {
            return ZoneId.of(zoneIdText);
        }
        catch (DateTimeException e) {
            LOGGER.warn("Cannot create ZoneId");
            return null;
        }
    }

    private static String getLocalDate(String input) {
        DateTimeFormatter format = null;
        for (Map.Entry<Pattern, DateTimeFormatter> pattern : DateFormats.getDatePatternsWithoutTimeInstance().entrySet()) {
            if (!pattern.getKey().matcher(input).matches()) continue;
            format = pattern.getValue();
            break;
        }
        if (format != null) {
            try {
                LocalDate ldt = LocalDate.parse(input, DateFormats.getFormatterInstance());
                return ldt.atStartOfDay().format(format);
            }
            catch (DateTimeParseException e) {
                LOGGER.warn("Input value cannot be formatted to LocalDate");
                return null;
            }
        }
        return null;
    }

    private static String getZonedDate(String input) {
        DateTimeFormatter format = null;
        for (Map.Entry<Pattern, DateTimeFormatter> pattern : DateFormats.getDatePatternsWithZoneInstance().entrySet()) {
            if (!pattern.getKey().matcher(input).matches()) continue;
            format = pattern.getValue();
            break;
        }
        if (format != null) {
            try {
                ZonedDateTime zdt = ZonedDateTime.parse(input, DateFormats.getFormatterInstance());
                return zdt.format(format);
            }
            catch (DateTimeParseException e) {
                LOGGER.warn("Input value cannot be parsed to ZonedDateTime");
                return null;
            }
        }
        return null;
    }

    public static Temporal getTemporal(String dateString) {
        HashMap<CallSite, DateTimeParseException> warnings = new HashMap<CallSite, DateTimeParseException>();
        if (dateString == null) {
            return null;
        }
        Comparable<Instant> temporal = null;
        try {
            temporal = Instant.parse(dateString);
        }
        catch (DateTimeParseException e) {
            warnings.put((CallSite)((Object)("Input value cannot be parsed to  instant " + dateString)), e);
        }
        if (temporal == null) {
            try {
                temporal = ZonedDateTime.parse(dateString, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                warnings.put((CallSite)((Object)("Input value cannot be parsed to ZonedDateTime " + dateString)), e);
            }
        }
        if (temporal == null) {
            try {
                temporal = LocalDateTime.parse(dateString, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                warnings.put((CallSite)((Object)("Input value cannot be parsed to LocalDateTime " + dateString)), e);
            }
        }
        if (temporal == null) {
            try {
                temporal = LocalDate.parse(dateString, DateTimeFormatter.ISO_LOCAL_DATE);
            }
            catch (DateTimeParseException e) {
                warnings.put((CallSite)((Object)("Input value cannot be parsed to LocalDate " + dateString)), e);
            }
        }
        if (temporal == null && !warnings.isEmpty()) {
            LOGGER.warn("Attempt to parse input value to temporal failed.");
            for (Map.Entry entry : warnings.entrySet()) {
            }
        }
        return temporal;
    }
}

