/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.linuxforhealth.api.Condition;
import io.github.linuxforhealth.api.Specification;
import io.github.linuxforhealth.api.Variable;
import io.github.linuxforhealth.core.expression.condition.ConditionUtil;
import io.github.linuxforhealth.hl7.expression.ExpressionType;
import io.github.linuxforhealth.hl7.expression.specification.SpecificationParser;
import io.github.linuxforhealth.hl7.expression.variable.VariableGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcherFactory;

@JsonDeserialize(builder=Builder.class)
public class ExpressionAttributes {
    private static final String OBJECT_TYPE = Object.class.getSimpleName();
    private String name;
    private final String type;
    private final String defaultValue;
    private final boolean isRequired;
    private final List<Specification> specs;
    private final List<Variable> variables;
    private final Condition condition;
    private final Map<String, String> constants;
    private final String value;
    private final String valueOf;
    private final boolean useGroup;
    private ExpressionType expressionType;
    private String toString;
    private final List<ExpressionAttributes> expressions;
    private final Map<String, ExpressionAttributes> expressionsMap;
    private final boolean isEvaluateLater;
    private boolean generateMultiple;

    private ExpressionAttributes(Builder exBuilder) {
        this.type = exBuilder.type == null ? OBJECT_TYPE : exBuilder.type;
        this.defaultValue = exBuilder.defaultValue;
        this.name = exBuilder.name;
        this.isRequired = exBuilder.isRequired;
        this.isEvaluateLater = exBuilder.isEvaluateLater;
        this.generateMultiple = exBuilder.generateList;
        this.specs = ExpressionAttributes.getSpecList(exBuilder.rawSpecs, exBuilder.useGroup, this.generateMultiple);
        this.condition = StringUtils.isNotBlank((CharSequence)exBuilder.rawCondition) ? ConditionUtil.createCondition(exBuilder.rawCondition, exBuilder.useGroup) : null;
        this.constants = new HashMap<String, String>();
        if (exBuilder.constants != null && !exBuilder.constants.isEmpty()) {
            this.constants.putAll(exBuilder.constants);
        }
        this.variables = new ArrayList<Variable>();
        if (exBuilder.rawVariables != null) {
            for (Map.Entry<String, String> e : exBuilder.rawVariables.entrySet()) {
                this.variables.add(VariableGenerator.parse(e.getKey(), e.getValue()));
            }
        }
        this.value = exBuilder.value;
        this.valueOf = exBuilder.valueOf;
        this.expressionType = exBuilder.expressionType;
        this.useGroup = exBuilder.useGroup;
        if (this.expressionType == null && CollectionUtils.isNotEmpty(this.specs)) {
            this.expressionType = ExpressionType.HL7SPEC;
        }
        this.expressions = exBuilder.expressions != null ? exBuilder.expressions : null;
        this.expressionsMap = exBuilder.expressionsMap != null ? exBuilder.expressionsMap : null;
    }

    public Map<String, ExpressionAttributes> getExpressionsMap() {
        return this.expressionsMap;
    }

    public boolean isUseGroup() {
        return this.useGroup;
    }

    public String getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public List<Specification> getSpecs() {
        return ImmutableList.copyOf(this.specs);
    }

    public List<Variable> getVariables() {
        return ImmutableList.copyOf(this.variables);
    }

    public Condition getFilter() {
        return this.condition;
    }

    public Map<String, String> getConstants() {
        return ImmutableMap.copyOf(this.constants);
    }

    public boolean isGenerateMultiple() {
        return this.generateMultiple;
    }

    public String getValue() {
        return this.value;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public String getValueOf() {
        return this.valueOf;
    }

    public String getName() {
        return this.name;
    }

    public List<ExpressionAttributes> getExpressions() {
        return this.expressions;
    }

    public static final ExpressionModifiers extractExpressionModifiers(String inputString, boolean generateMultiple) {
        boolean extractMultiple = generateMultiple;
        boolean retainEmpty = false;
        String expression = inputString;
        if (StringUtils.endsWith((CharSequence)expression, (CharSequence)"*") && !StringUtils.endsWith((CharSequence)expression, (CharSequence)".*")) {
            expression = StringUtils.removeEnd((String)expression, (String)"*");
            extractMultiple = true;
        }
        if (StringUtils.endsWith((CharSequence)expression, (CharSequence)"&")) {
            expression = StringUtils.removeEnd((String)expression, (String)"&");
            retainEmpty = true;
        }
        if (StringUtils.endsWith((CharSequence)expression, (CharSequence)"*") && !StringUtils.endsWith((CharSequence)expression, (CharSequence)".*")) {
            expression = StringUtils.removeEnd((String)expression, (String)"*");
            extractMultiple = true;
        }
        expression = StringUtils.strip((String)expression);
        return new ExpressionModifiers(extractMultiple, retainEmpty, expression);
    }

    public static List<Specification> getSpecList(String inputString, boolean useGroup, boolean generateMultiple) {
        ExpressionModifiers exp = ExpressionAttributes.extractExpressionModifiers(inputString, generateMultiple);
        ArrayList<Specification> specs = new ArrayList<Specification>();
        if (StringUtils.isNotBlank((CharSequence)exp.expression)) {
            StringTokenizer st = new StringTokenizer(exp.expression, "|").setIgnoreEmptyTokens(true).setTrimmerMatcher(StringMatcherFactory.INSTANCE.spaceMatcher());
            st.getTokenList().forEach(s -> specs.add(SpecificationParser.parse(s, exp.extractMultiple, useGroup, exp.retainEmpty)));
        }
        return specs;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE, (boolean)false, (boolean)false, (boolean)true, null);
        }
        return this.toString;
    }

    public boolean isEvaluateLater() {
        return this.isEvaluateLater;
    }

    public void setName(String key) {
        this.name = key;
    }

    public static class ExpressionModifiers {
        private boolean extractMultiple = false;
        private boolean retainEmpty = false;
        private String expression = "";

        ExpressionModifiers(boolean theExtractMultiple, boolean theRetainEmpty, String theExpression) {
            this.extractMultiple = theExtractMultiple;
            this.retainEmpty = theRetainEmpty;
            this.expression = theExpression;
        }

        public boolean getExtractMultiple() {
            return this.extractMultiple;
        }

        public boolean getRetainEmpty() {
            return this.retainEmpty;
        }

        public String getExpression() {
            return this.expression;
        }
    }

    public static class Builder {
        private String name;
        private String type;
        private String defaultValue;
        private boolean isRequired;
        private String rawSpecs;
        private String rawCondition;
        private Map<String, String> rawVariables;
        private Map<String, String> constants;
        private boolean useGroup;
        private ExpressionType expressionType;
        private String valueOf;
        private String value;
        private boolean generateList;
        private List<ExpressionAttributes> expressions;
        private Map<String, ExpressionAttributes> expressionsMap;
        private boolean isEvaluateLater;

        public Builder() {
        }

        public Builder(String singleValue) {
            this.value = singleValue;
            this.expressionType = ExpressionType.SIMPLE;
        }

        public boolean isUseGroup() {
            return this.useGroup;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withDefault(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withRequired(boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public Builder withEvaluateLater(boolean isEvaluateLater) {
            this.isEvaluateLater = isEvaluateLater;
            return this;
        }

        public Builder withSpecs(String rawSpecs) {
            this.rawSpecs = rawSpecs;
            return this;
        }

        public Builder withUseGroup(boolean useGroup) {
            this.useGroup = useGroup;
            return this;
        }

        public Builder withCondition(String rawCondition) {
            this.rawCondition = rawCondition;
            return this;
        }

        public Builder withVars(Map<String, String> rawVariables) {
            this.rawVariables = rawVariables;
            return this;
        }

        public Builder withConstants(Map<String, String> constants) {
            this.constants = constants;
            return this;
        }

        public Builder withExpressions(List<ExpressionAttributes> expressions) {
            this.expressions = expressions;
            return this;
        }

        public Builder withExpressionsMap(Map<String, ExpressionAttributes> expressionsMap) {
            this.expressionsMap = expressionsMap;
            return this;
        }

        public Builder withValueOf(String valueOf) {
            this.valueOf = StringUtils.trim((String)valueOf);
            if (this.expressionType == null) {
                this.expressionType = ExpressionType.SIMPLE;
            }
            return this;
        }

        public Builder withExpressionType(String expressionType) {
            this.expressionType = (ExpressionType)EnumUtils.getEnumIgnoreCase(ExpressionType.class, (String)expressionType);
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            this.expressionType = ExpressionType.SIMPLE;
            return this;
        }

        public Builder withGenerateList(boolean generateList) {
            this.generateList = generateList;
            return this;
        }

        public ExpressionAttributes build() {
            return new ExpressionAttributes(this);
        }
    }
}

