/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.Variable;
import io.github.linuxforhealth.core.expression.EmptyEvaluationResult;
import io.github.linuxforhealth.hl7.expression.AbstractExpression;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JEXLExpression
extends AbstractExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(JEXLExpression.class);

    @JsonCreator
    public JEXLExpression(ExpressionAttributes expAttr) {
        super(expAttr);
    }

    @Override
    public EvaluationResult evaluateExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult baseValue) {
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
        for (Variable v : this.getVariables()) {
            if (localContextValues.containsKey(v.getVariableName())) continue;
            localContextValues.put(v.getVariableName(), new EmptyEvaluationResult());
        }
        LOGGER.info("Evaluating expression");
        return dataSource.evaluateJexlExpression(this.getExpressionAttr().getValueOf(), contextValues);
    }
}

