/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.Expression;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.hl7.expression.AbstractExpression;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import io.github.linuxforhealth.hl7.resource.ResourceEvaluationResult;
import io.github.linuxforhealth.hl7.resource.deserializer.HL7DataBasedResourceDeserializer;
import io.github.linuxforhealth.hl7.util.ExpressionUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedExpression
extends AbstractExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(NestedExpression.class);
    private Map<String, Expression> childexpressions = new HashMap<String, Expression>();
    private boolean generateMap;

    public NestedExpression(ExpressionAttributes attr) {
        super(attr);
        if (attr.getExpressions() != null) {
            int index = 0;
            for (ExpressionAttributes nestedattrs : attr.getExpressions()) {
                Expression e = HL7DataBasedResourceDeserializer.generateExpression(nestedattrs);
                if (e == null) continue;
                this.childexpressions.put("key" + index, e);
                ++index;
            }
            this.generateMap = false;
        } else if (attr.getExpressionsMap() != null) {
            for (Map.Entry<String, ExpressionAttributes> nestedattrs : attr.getExpressionsMap().entrySet()) {
                Expression e = HL7DataBasedResourceDeserializer.generateExpression(nestedattrs.getValue());
                if (e == null) continue;
                this.childexpressions.put(nestedattrs.getKey(), e);
            }
            this.generateMap = true;
        }
        Preconditions.checkState((!this.childexpressions.isEmpty() ? 1 : 0) != 0, (Object)"childexpressions cannot be null or empty");
    }

    @Override
    protected EvaluationResult evaluateExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult baseValue) {
        LOGGER.info("Evalutating expression");
        ResourceEvaluationResult result = ExpressionUtility.evaluate(dataSource, contextValues, baseValue, this.childexpressions);
        if (result == null || result.getResolveValues() == null || result.getResolveValues().isEmpty()) {
            return EvaluationResultFactory.getEvaluationResult(null);
        }
        if (this.generateMap) {
            return EvaluationResultFactory.getEvaluationResult(result.getResolveValues(), result.getAdditionalResolveValues());
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object o : result.getResolveValues().values()) {
            if (o instanceof Collection) {
                values.addAll((Collection)o);
                continue;
            }
            values.add(o);
        }
        return EvaluationResultFactory.getEvaluationResult(values, result.getAdditionalResolveValues());
    }
}

