/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.core.expression.ContextValueUtils;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.core.expression.VariableUtils;
import io.github.linuxforhealth.hl7.data.SimpleDataTypeMapper;
import io.github.linuxforhealth.hl7.data.ValueExtractor;
import io.github.linuxforhealth.hl7.expression.AbstractExpression;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import io.github.linuxforhealth.hl7.util.ExpressionUtility;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SimpleExpression
extends AbstractExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleExpression.class);
    private String value;
    private ImmutablePair<String, String> fetch;

    @JsonCreator
    public SimpleExpression(ExpressionAttributes expAttr) {
        super(expAttr);
        this.value = expAttr.getValue();
        if (StringUtils.isBlank((CharSequence)this.value)) {
            this.value = expAttr.getValueOf();
        }
        if (this.value != null && this.value.startsWith("$") && this.value.contains(":")) {
            String[] tokens = StringUtils.split((String)this.value, (String)":", (int)2);
            this.fetch = ImmutablePair.of((Object)tokens[0], (Object)tokens[1]);
        }
    }

    @Override
    public EvaluationResult evaluateExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult baseValue) {
        Preconditions.checkArgument((contextValues != null ? 1 : 0) != 0, (Object)"contextValues cannot be null");
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
        if (baseValue != null && !baseValue.isEmpty()) {
            localContextValues.put(baseValue.getIdentifier(), baseValue);
            localContextValues.put("BASE_VALUE", baseValue);
        }
        if (this.fetch != null) {
            return this.evaluateExpressionForFetch(localContextValues, baseValue);
        }
        String resolvedValue = null;
        if (VariableUtils.isVar(this.value)) {
            boolean fuzzyMatch = VariableUtils.isFuzzyMatch(this.value);
            EvaluationResult obj = ContextValueUtils.getVariableValuesFromVariableContextMap(this.value, (Map<String, EvaluationResult>)ImmutableMap.copyOf(localContextValues), this.getExpressionAttr().isUseGroup(), fuzzyMatch);
            if (obj != null && !obj.isEmpty()) {
                resolvedValue = obj.getValue();
            }
        } else {
            resolvedValue = this.value;
        }
        if (resolvedValue != null) {
            return this.getValueOfSpecifiedType(resolvedValue);
        }
        return null;
    }

    private EvaluationResult evaluateExpressionForFetch(Map<String, EvaluationResult> contextValues, EvaluationResult basevalue) {
        EvaluationResult resource;
        if ("BASE_VALUE".equals(this.fetch.getKey())) {
            resource = basevalue;
        } else {
            boolean fuzzyMatch = VariableUtils.isFuzzyMatch((String)this.fetch.getKey());
            resource = ContextValueUtils.getVariableValuesFromVariableContextMap((String)this.fetch.getKey(), contextValues, this.getExpressionAttr().isUseGroup(), fuzzyMatch);
        }
        return ExpressionUtility.extractComponent(this.fetch, resource);
    }

    private EvaluationResult getValueOfSpecifiedType(Object obj) {
        if (obj != null) {
            ValueExtractor<Object, ?> resolver = SimpleDataTypeMapper.getValueResolver(this.getType());
            return EvaluationResultFactory.getEvaluationResult(resolver.apply(obj));
        }
        return null;
    }
}

