/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.message;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.ResourceModel;
import io.github.linuxforhealth.hl7.message.HL7Segment;
import io.github.linuxforhealth.hl7.resource.ResourceReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize(builder=Builder.class)
public class HL7FHIRResourceTemplateAttributes {
    private String resourceName;
    private boolean repeats;
    private String resourcePath;
    private boolean isReferenced;
    private HL7Segment segment;
    private List<HL7Segment> additionalSegments;
    private ResourceModel resource;
    private List<String> group;

    public HL7FHIRResourceTemplateAttributes(Builder builder) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)builder.resourceName), (Object)"resourceName cannot be null");
        this.resourceName = builder.resourceName;
        this.resourcePath = builder.resourcePath;
        this.repeats = builder.repeats;
        this.isReferenced = builder.isReferenced;
        this.additionalSegments = new ArrayList<HL7Segment>();
        builder.rawAdditionalSegments.forEach(e -> this.additionalSegments.add(HL7Segment.parse(e, builder.group)));
        this.segment = HL7Segment.parse(builder.rawSegment, builder.group);
        Preconditions.checkArgument((this.segment != null ? 1 : 0) != 0, (Object)"primary segment cannot be null");
        this.resource = builder.resourceModel != null ? builder.resourceModel : HL7FHIRResourceTemplateAttributes.generateResourceModel(this.resourcePath);
        Preconditions.checkArgument((this.resource != null ? 1 : 0) != 0, (Object)"Resource model cannot be null");
        this.group = HL7Segment.parseGroup(builder.group);
    }

    public ResourceModel getResource() {
        return this.resource;
    }

    public HL7Segment getSegment() {
        return this.segment;
    }

    public List<HL7Segment> getAdditionalSegments() {
        return new ArrayList<HL7Segment>(this.additionalSegments);
    }

    public List<String> getGroup() {
        return new ArrayList<String>(this.group);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public boolean isReferenced() {
        return this.isReferenced;
    }

    private static ResourceModel generateResourceModel(String resourcePath) {
        return ResourceReader.getInstance().generateResourceModel(resourcePath);
    }

    public static class Builder {
        private String resourceName;
        private String rawSegment;
        private List<String> rawAdditionalSegments = new ArrayList<String>();
        private String resourcePath;
        private String group;
        private boolean isReferenced;
        private boolean repeats;
        private ResourceModel resourceModel;

        public Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public Builder withSegment(String rawSegment) {
            this.rawSegment = rawSegment;
            return this;
        }

        public Builder withAdditionalSegments(List<String> rawAdditionalSegments) {
            if (rawAdditionalSegments != null) {
                this.rawAdditionalSegments = new ArrayList<String>(rawAdditionalSegments);
            }
            return this;
        }

        public Builder withResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        public Builder withGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder withRepeats(boolean repeats) {
            this.repeats = repeats;
            return this;
        }

        public Builder withIsReferenced(boolean isReferenced) {
            this.isReferenced = isReferenced;
            return this;
        }

        public Builder withResourceModel(ResourceModel resourceModel) {
            this.resourceModel = resourceModel;
            return this;
        }

        public HL7FHIRResourceTemplateAttributes build() {
            return new HL7FHIRResourceTemplateAttributes(this);
        }
    }
}

