/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.message;

import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.Specification;
import io.github.linuxforhealth.core.data.JexlEngineUtil;
import io.github.linuxforhealth.core.exception.DataExtractionException;
import io.github.linuxforhealth.core.expression.EmptyEvaluationResult;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.core.expression.SimpleEvaluationResult;
import io.github.linuxforhealth.hl7.data.Hl7RelatedGeneralUtils;
import io.github.linuxforhealth.hl7.expression.specification.HL7Specification;
import io.github.linuxforhealth.hl7.parsing.HL7DataExtractor;
import io.github.linuxforhealth.hl7.parsing.result.ParsingResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7MessageData
implements InputDataExtractor {
    private HL7DataExtractor hde;
    private static final Logger LOGGER = LoggerFactory.getLogger(HL7MessageData.class);
    protected static final Pattern HL7_SPEC_SPLITTER = Pattern.compile(".");
    private static final JexlEngineUtil JEXL = new JexlEngineUtil("GeneralUtils", Hl7RelatedGeneralUtils.class);

    public HL7MessageData(HL7DataExtractor hde) {
        Preconditions.checkArgument((hde != null ? 1 : 0) != 0, (Object)"Hl7DataExtractor cannot be null.");
        this.hde = hde;
    }

    @Override
    public EvaluationResult extractMultipleValuesForSpec(Specification spec, Map<String, EvaluationResult> contextValues) {
        HL7Specification hl7spec = (HL7Specification)spec;
        EvaluationResult valuefromVariables = StringUtils.isNotBlank((CharSequence)hl7spec.getSegment()) ? contextValues.get(hl7spec.getSegment()) : (StringUtils.isNotBlank((CharSequence)hl7spec.getField()) ? contextValues.get(hl7spec.getField()) : null);
        Object hl7object = null;
        if (valuefromVariables != null) {
            hl7object = valuefromVariables.getValue();
        }
        if (hl7object instanceof List) {
            ArrayList<Object> extractedValues = new ArrayList<Object>();
            for (Object hl7objectFromList : (List)hl7object) {
                Object result = this.extractValue(hl7spec, hl7objectFromList);
                if (result instanceof List) {
                    extractedValues.addAll((List)result);
                    continue;
                }
                if (result != null) {
                    extractedValues.add(result);
                    continue;
                }
                if (result != null || !hl7spec.getRetainEmptyFields()) continue;
                extractedValues.add("");
            }
            return EvaluationResultFactory.getEvaluationResult(extractedValues);
        }
        return EvaluationResultFactory.getEvaluationResult(this.extractValue(hl7spec, hl7object));
    }

    private Object extractValue(HL7Specification hl7spec, Object obj) {
        EvaluationResult res = null;
        try {
            if (obj instanceof Segment) {
                res = this.extractSpecValuesFromSegment(obj, hl7spec);
            } else if (obj instanceof Type) {
                res = this.extractSpecValuesFromField(obj, hl7spec);
            } else if (obj == null) {
                res = this.extractSpecValues(hl7spec);
            }
        }
        catch (DataExtractionException e) {
            LOGGER.warn("cannot extract value for variable {} ", (Object)hl7spec);
        }
        if (res != null) {
            return res.getValue();
        }
        return null;
    }

    private EvaluationResult extractSpecValues(HL7Specification hl7spec) {
        ParsingResult<Object> res;
        if (StringUtils.isNotBlank((CharSequence)hl7spec.getSegment()) && (res = StringUtils.isNotBlank((CharSequence)hl7spec.getField()) ? this.hde.get(hl7spec.getSegment(), hl7spec.getField()) : this.hde.getAllStructures(hl7spec.getSegment())) != null) {
            return EvaluationResultFactory.getEvaluationResult(res.getValue());
        }
        return new EmptyEvaluationResult();
    }

    private EvaluationResult extractSpecValuesFromSegment(Object obj, HL7Specification hl7spec) {
        if (StringUtils.isNotBlank((CharSequence)hl7spec.getField()) && NumberUtils.isCreatable((String)hl7spec.getField())) {
            int field = NumberUtils.toInt((String)hl7spec.getField());
            ParsingResult<Type> res = this.hde.getTypes((Segment)obj, field);
            if (res != null && !res.isEmpty() && hl7spec.getComponent() > 0) {
                return this.extractSpecValuesFromField(res.getValues().get(0), hl7spec);
            }
            if (res != null && !res.isEmpty()) {
                return new SimpleEvaluationResult<List<Type>>(res.getValues());
            }
            return null;
        }
        return EvaluationResultFactory.getEvaluationResult(obj);
    }

    private EvaluationResult extractSpecValuesFromField(Object obj, HL7Specification hl7spec) {
        if (hl7spec.getComponent() >= 0) {
            ParsingResult<Type> res = hl7spec.getSubComponent() >= 0 ? this.hde.getComponent((Type)obj, hl7spec.getComponent(), hl7spec.getSubComponent()) : this.hde.getComponent((Type)obj, hl7spec.getComponent());
            if (res != null && !res.isEmpty()) {
                return new SimpleEvaluationResult<List<Type>>(res.getValues());
            }
            return null;
        }
        return EvaluationResultFactory.getEvaluationResult(obj);
    }

    public HL7DataExtractor getHL7DataParser() {
        return this.hde;
    }

    @Override
    public EvaluationResult evaluateJexlExpression(String expression, Map<String, EvaluationResult> contextValues) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)expression), (Object)"jexlExp cannot be blank");
        Preconditions.checkArgument((contextValues != null ? 1 : 0) != 0, (Object)"context cannot be null");
        String trimedJexlExp = StringUtils.trim((String)expression);
        HashMap<String, Object> localContext = new HashMap<String, Object>();
        HashMap<String, EvaluationResult> resolvedVariables = new HashMap<String, EvaluationResult>(contextValues);
        resolvedVariables.forEach((key, value) -> localContext.put((String)key, value.getValue()));
        Object obj = JEXL.evaluate(trimedJexlExp, localContext);
        return EvaluationResultFactory.getEvaluationResult(obj);
    }

    @Override
    public String getName() {
        return this.hde.getMessageType();
    }

    @Override
    public String getId() {
        return this.hde.getMessageId();
    }

    @Override
    public EvaluationResult extractValueForSpec(Specification spec, Map<String, EvaluationResult> contextValues) {
        EvaluationResult fetchedValue = this.extractMultipleValuesForSpec(spec, contextValues);
        if (fetchedValue != null && !fetchedValue.isEmpty()) {
            return EvaluationResultFactory.getEvaluationResult(HL7MessageData.getSingleValue(fetchedValue.getValue()));
        }
        return new EmptyEvaluationResult();
    }

    private static Object getSingleValue(Object object) {
        if (object instanceof List) {
            List value = (List)object;
            if (value.isEmpty()) {
                return null;
            }
            return value.get(0);
        }
        return object;
    }
}

