/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.FHIRResourceTemplate;
import io.github.linuxforhealth.api.MessageEngine;
import io.github.linuxforhealth.api.MessageTemplate;
import io.github.linuxforhealth.hl7.message.HL7FHIRResourceTemplate;
import io.github.linuxforhealth.hl7.message.HL7MessageData;
import io.github.linuxforhealth.hl7.parsing.HL7DataExtractor;
import io.github.linuxforhealth.hl7.parsing.HL7HapiParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7MessageModel
implements MessageTemplate<Message> {
    private List<FHIRResourceTemplate> resources;
    private String messageName;
    private static final Logger LOGGER = LoggerFactory.getLogger(HL7MessageModel.class);

    @JsonCreator
    public HL7MessageModel(@JsonProperty(value="messageName") String messageName, @JsonProperty(value="resources") List<HL7FHIRResourceTemplate> resources) {
        this.messageName = messageName;
        this.resources = new ArrayList<FHIRResourceTemplate>();
        if (resources != null && !resources.isEmpty()) {
            this.resources.addAll(resources);
        }
    }

    private void handleException(Exception e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        StringBuilder classAndStack = new StringBuilder();
        classAndStack.append(e.getClass() + "\n");
        for (int i = 0; i < stackTrace.length; ++i) {
            classAndStack.append(stackTrace[i] + "\n");
        }
        LOGGER.error("Error transforming HL7 message. {}", (Object)classAndStack);
    }

    public String convert(String message, MessageEngine engine) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)message), (Object)"Input Hl7 message cannot be blank");
        HL7HapiParser hparser = null;
        try {
            hparser = new HL7HapiParser();
            Message hl7message = hparser.getParser().parse(message);
            Bundle bundle = this.convert(hl7message, engine);
            String string = engine.getFHIRContext().encodeResourceToString(bundle);
            return string;
        }
        catch (HL7Exception e) {
            throw new IllegalArgumentException("Cannot parse the message.", e);
        }
        finally {
            if (hparser != null) {
                hparser.getContext().close();
            }
        }
    }

    @Override
    public Bundle convert(Message message, MessageEngine engine) {
        Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"Input Hl7 message cannot be null");
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (Object)"MessageEngine cannot be null");
        HL7DataExtractor hl7DTE = new HL7DataExtractor(message);
        HL7MessageData dataSource = new HL7MessageData(hl7DTE);
        Bundle bundle = null;
        try {
            bundle = engine.transform(dataSource, this.getResources(), new HashMap<String, EvaluationResult>());
            this.deduplicate(bundle);
            engine.getFHIRContext().validate(bundle);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return bundle;
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    @Override
    public List<FHIRResourceTemplate> getResources() {
        return new ArrayList<FHIRResourceTemplate>(this.resources);
    }

    private void deduplicate(Bundle bundle) {
        List entries = bundle.getEntry();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Bundle.BundleEntryComponent entry = (Bundle.BundleEntryComponent)i.next();
            if (!entry.getFullUrl().startsWith("Organization/") || !this.duplicateFound(entry, entries)) continue;
            i.remove();
        }
    }

    private boolean duplicateFound(Bundle.BundleEntryComponent entry, List<Bundle.BundleEntryComponent> entries) {
        String targetUrl = entry.getFullUrl();
        Integer foundCount = 0;
        for (Bundle.BundleEntryComponent component : entries) {
            if (!component.getFullUrl().equals(targetUrl)) continue;
            Integer n = foundCount;
            Integer n2 = foundCount = Integer.valueOf(foundCount + 1);
        }
        return foundCount > 1;
    }
}

