/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import io.github.linuxforhealth.api.ResourceModel;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.core.config.ConverterConfiguration;
import io.github.linuxforhealth.hl7.message.HL7FHIRResourceTemplate;
import io.github.linuxforhealth.hl7.message.HL7FHIRResourceTemplateAttributes;
import io.github.linuxforhealth.hl7.message.HL7MessageModel;
import io.github.linuxforhealth.hl7.resource.HL7DataBasedResourceModel;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceReader {
    private final Logger LOGGER = LoggerFactory.getLogger(ResourceReader.class);
    private static ResourceReader reader;
    private final ConverterConfiguration converterConfig = ConverterConfiguration.getInstance();

    private static String loadFileResource(File fileResourceConfiguration) throws IOException {
        return FileUtils.readFileToString((File)fileResourceConfiguration, (Charset)StandardCharsets.UTF_8);
    }

    private static String loadClassPathResource(String resourceConfigurationPath) throws IOException {
        return IOUtils.resourceToString((String)resourceConfigurationPath, (Charset)StandardCharsets.UTF_8, (ClassLoader)ResourceReader.class.getClassLoader());
    }

    public String getResource(String resourcePath) {
        String resourceFolderName = this.converterConfig.getResourceFolder();
        String additionalResourcesFolderName = this.converterConfig.getAdditionalResourcesLocation();
        String resource = null;
        try {
            Path alternateResourceFolderFilePath;
            Path resourceFolderFilePath;
            if (resourceFolderName != null && (resourceFolderFilePath = Paths.get(resourceFolderName, resourcePath)).toFile().exists()) {
                resource = ResourceReader.loadFileResource(resourceFolderFilePath.toFile());
            }
            if (resource == null && additionalResourcesFolderName != null && (alternateResourceFolderFilePath = Paths.get(additionalResourcesFolderName, resourcePath)).toFile().exists()) {
                resource = ResourceReader.loadFileResource(alternateResourceFolderFilePath.toFile());
            }
            if (resource == null) {
                resource = ResourceReader.loadClassPathResource(resourcePath);
            }
        }
        catch (IOException ioEx) {
            String msg = "Unable to load resource " + resourcePath;
            throw new IllegalArgumentException(msg, ioEx);
        }
        return resource;
    }

    public Map<String, HL7MessageModel> getMessageTemplates() {
        HashMap<String, HL7MessageModel> messagetemplates = new HashMap<String, HL7MessageModel>();
        List<String> supportedMessageTemplates = ConverterConfiguration.getInstance().getSupportedMessageTemplates();
        if (this.hasWildcard(supportedMessageTemplates)) {
            supportedMessageTemplates.clear();
            supportedMessageTemplates = this.findAllMessageTemplateNames();
        }
        for (String template : supportedMessageTemplates) {
            HL7MessageModel rm = this.getMessageModel(template);
            messagetemplates.put(Files.getNameWithoutExtension((String)template), rm);
        }
        return messagetemplates;
    }

    private boolean hasWildcard(List<String> supportedMessageTemplates) {
        for (String template : supportedMessageTemplates) {
            if (!template.contains("*")) continue;
            return true;
        }
        return false;
    }

    private List<String> findAllMessageTemplateNames() {
        int i;
        ArrayList<String> foundTemplates = new ArrayList<String>();
        File folder = new File(this.converterConfig.getResourceFolder() + "/hl7/message/");
        File[] listOfFiles = folder.listFiles();
        for (i = 0; listOfFiles != null && i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile()) continue;
            foundTemplates.add(listOfFiles[i].getName());
        }
        folder = new File(this.converterConfig.getAdditionalResourcesLocation() + "/hl7/message/");
        listOfFiles = folder.listFiles();
        for (i = 0; listOfFiles != null && i < listOfFiles.length; ++i) {
            if (!listOfFiles[i].isFile()) continue;
            foundTemplates.add(listOfFiles[i].getName());
        }
        return foundTemplates;
    }

    private HL7MessageModel getMessageModel(String templateName) {
        Object yamlizedTemplateName = templateName.endsWith(".yml") ? templateName : templateName + ".yml";
        String templateFileContent = this.getResourceInHl7Folder("message/" + (String)yamlizedTemplateName);
        if (StringUtils.isNotBlank((CharSequence)templateFileContent)) {
            try {
                JsonNode parent = ObjectMapperUtil.getYAMLInstance().readTree(templateFileContent);
                Preconditions.checkState((parent != null ? 1 : 0) != 0, (Object)"Parent node from template file cannot be null");
                JsonNode resourceNodes = parent.get("resources");
                Preconditions.checkState((resourceNodes != null && !resourceNodes.isEmpty() ? 1 : 0) != 0, (Object)"List of resources from Parent node from template file cannot be null or empty");
                List templateAttributes = (List)ObjectMapperUtil.getYAMLInstance().convertValue((Object)resourceNodes, (TypeReference)new TypeReference<List<HL7FHIRResourceTemplateAttributes>>(){});
                ArrayList<HL7FHIRResourceTemplate> templates = new ArrayList<HL7FHIRResourceTemplate>();
                templateAttributes.forEach(t -> templates.add(new HL7FHIRResourceTemplate((HL7FHIRResourceTemplateAttributes)t)));
                Preconditions.checkState((templateAttributes != null && !templateAttributes.isEmpty() ? 1 : 0) != 0, (Object)"TemplateAttributes generated from template file cannot be null or empty");
                return new HL7MessageModel(templateName, templates);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error encountered in processing the template" + templateName, e);
            }
        }
        throw new IllegalArgumentException("File not present:" + templateName);
    }

    public ResourceModel generateResourceModel(String path) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)path), (Object)"Path for resource cannot be blank");
        String templateFileContent = this.getResourceInHl7Folder(path + ".yml");
        try {
            InjectableValues.Std injValues = new InjectableValues.Std().addValue("resourceName", (Object)path);
            return (ResourceModel)ObjectMapperUtil.getYAMLInstance().setInjectableValues((InjectableValues)injValues).readValue(templateFileContent, HL7DataBasedResourceModel.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error encountered in processing the template" + path, e);
        }
    }

    public static ResourceReader getInstance() {
        if (reader == null) {
            reader = new ResourceReader();
        }
        return reader;
    }

    public static void reset() {
        reader = null;
    }

    public String getResourceInHl7Folder(String path) {
        return this.getResource("hl7/" + path);
    }
}

