/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.github.linuxforhealth.core.exception.DataExtractionException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JexlEngineUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JexlEngineUtil.class);
    private static final List<String> OPERATORS = Lists.newArrayList((Object[])new String[]{">", "<", "==", "!=", ">=", "<="});
    private JexlEngine jexl;
    private Map<String, Object> functions = new HashMap<String, Object>();

    public JexlEngineUtil() {
        this.jexl = new JexlBuilder().silent(false).debug(true).strict(true).create();
        LOGGER.info("silent:{} , strict :{} ", (Object)this.jexl.isSilent(), (Object)this.jexl.isStrict());
        this.functions.put(StringUtils.class.getSimpleName(), StringUtils.class);
        this.functions.put(NumberUtils.class.getSimpleName(), NumberUtils.class);
        this.functions.put(String.class.getSimpleName(), String.class);
        this.functions.put(UUID.class.getSimpleName(), UUID.class);
    }

    public JexlEngineUtil(Map<String, Object> functions) {
        this();
        functions.putAll(functions);
    }

    public JexlEngineUtil(String name, Object function) {
        this();
        this.functions.put(name, function);
    }

    public Object evaluate(String jexlExp, Map<String, Object> context) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jexlExp), (Object)"jexlExp cannot be blank");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context cannot be null");
        String trimedJexlExp = StringUtils.trim((String)jexlExp);
        this.validateExpression(trimedJexlExp);
        LOGGER.debug("Evaluating expression : {}", (Object)trimedJexlExp);
        HashMap<String, Object> localContext = new HashMap<String, Object>(this.functions);
        localContext.putAll(context);
        JexlExpression exp = this.jexl.createExpression(trimedJexlExp);
        MapContext jc = new MapContext();
        localContext.entrySet().forEach(arg_0 -> JexlEngineUtil.lambda$evaluate$0((JexlContext)jc, arg_0));
        try {
            Object obj = exp.evaluate((JexlContext)jc);
            LOGGER.debug("Evaluated expression : {}, returning object {}", (Object)trimedJexlExp, obj);
            return obj;
        }
        catch (JexlException e) {
            throw new DataExtractionException("Exception encountered during JEXL expression evaluation", (Exception)((Object)e));
        }
    }

    public boolean evaluateCondition(String jexlExp, Map<String, Object> context) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jexlExp), (Object)"jexlExp cannot be blank");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context cannot be null");
        String trimedJexlExp = StringUtils.trim((String)jexlExp);
        JexlEngineUtil.validateCondition(trimedJexlExp);
        LOGGER.debug("Evaluating condiitional expression : {}", (Object)trimedJexlExp);
        HashMap<String, Object> localContext = new HashMap<String, Object>(this.functions);
        localContext.putAll(context);
        JexlExpression exp = this.jexl.createExpression(trimedJexlExp);
        MapContext jc = new MapContext();
        localContext.entrySet().forEach(arg_0 -> JexlEngineUtil.lambda$evaluateCondition$1((JexlContext)jc, arg_0));
        boolean obj = (Boolean)exp.evaluate((JexlContext)jc);
        LOGGER.debug("Evaluated expression : {}, returning object {}", (Object)trimedJexlExp, (Object)obj);
        return obj;
    }

    static void validateCondition(String input) {
        boolean isValid = false;
        StringTokenizer strtoken = new StringTokenizer(input, " ").setIgnoreEmptyTokens(true);
        if (strtoken.getTokenList().size() == 3) {
            String var1 = strtoken.nextToken();
            String operator = strtoken.nextToken();
            String var2 = strtoken.nextToken();
            if (StringUtils.isAlphanumeric((CharSequence)var1) && StringUtils.isAlphanumeric((CharSequence)var2) && OPERATORS.contains(operator)) {
                isValid = true;
            }
        }
        if (!isValid) {
            throw new IllegalArgumentException("Condition not supported, only the following format is supported, value1 <conditionOperator> value2, input:" + input);
        }
    }

    private void validateExpression(String jexlExp) {
        StringTokenizer stk = new StringTokenizer(jexlExp, ".").setIgnoreEmptyTokens(true);
        String tok = stk.nextToken();
        if (stk.getTokenList().size() < 2 || this.functions.get(tok) == null) {
            throw new IllegalArgumentException("Expression has unsupported function: " + tok);
        }
        if (jexlExp.contains(";")) {
            throw new IllegalArgumentException("Expression cannot contain character ; Expression: " + jexlExp);
        }
    }

    private static /* synthetic */ void lambda$evaluateCondition$1(JexlContext jc, Map.Entry e) {
        jc.set((String)e.getKey(), e.getValue());
    }

    private static /* synthetic */ void lambda$evaluate$0(JexlContext jc, Map.Entry e) {
        jc.set((String)e.getKey(), e.getValue());
    }
}

