/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.expression;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;

public class VariableUtils {
    private VariableUtils() {
    }

    public static boolean isVar(String hl7spec) {
        return StringUtils.isNotBlank((CharSequence)hl7spec) && hl7spec.startsWith("$") && hl7spec.length() > 1;
    }

    public static String getVarName(String name) {
        if (VariableUtils.isVar(name) && StringUtils.contains((CharSequence)name, (CharSequence)".")) {
            StringTokenizer stk = new StringTokenizer(name, ".");
            return StringUtils.removeStart((String)stk.nextToken(), (String)"$");
        }
        if (VariableUtils.isVar(name)) {
            return StringUtils.removeStart((String)name, (String)"$");
        }
        return name;
    }
}

