/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.expression.condition;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.Condition;
import io.github.linuxforhealth.core.expression.condition.CheckNotNull;
import io.github.linuxforhealth.core.expression.condition.CheckNull;
import io.github.linuxforhealth.core.expression.condition.CompountAndCondition;
import io.github.linuxforhealth.core.expression.condition.CompountORCondition;
import io.github.linuxforhealth.core.expression.condition.SimpleBiCondition;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;

public class ConditionUtil {
    private ConditionUtil() {
    }

    public static Condition createCondition(String conditionString) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)conditionString), (Object)"conditionString cannot be blank or null.");
        StringTokenizer ors = new StringTokenizer(conditionString, "||");
        StringTokenizer ands = new StringTokenizer(conditionString, "&&");
        if (ors.getTokenList().size() > 1) {
            return ConditionUtil.getListOrConditions(ors);
        }
        if (ands.getTokenList().size() > 1) {
            return ConditionUtil.getListAndConditions(ands);
        }
        return ConditionUtil.createSimpleCondition(conditionString);
    }

    private static Condition createSimpleCondition(String conditionString) {
        StringTokenizer stk = new StringTokenizer(conditionString);
        if (stk.getTokenList().size() == 2) {
            String var1 = stk.nextToken();
            String var2 = stk.nextToken();
            if (var2.equalsIgnoreCase("NOT_NULL")) {
                return new CheckNotNull(var1);
            }
            if (var2.equalsIgnoreCase("NULL")) {
                return new CheckNull(var1);
            }
            throw new IllegalArgumentException("Condition string incorrect format");
        }
        if (stk.getTokenList().size() == 3) {
            String var1 = stk.nextToken();
            String operator = stk.nextToken();
            String var2 = stk.nextToken();
            return new SimpleBiCondition(var1, var2, operator);
        }
        throw new IllegalArgumentException("Condition string incorrect format");
    }

    private static CompountAndCondition getListAndConditions(StringTokenizer ands) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (String tok : ands.getTokenList()) {
            conditions.add(ConditionUtil.createSimpleCondition(tok));
        }
        return new CompountAndCondition(conditions);
    }

    private static CompountORCondition getListOrConditions(StringTokenizer ors) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (String tok : ors.getTokenList()) {
            conditions.add(ConditionUtil.createSimpleCondition(tok));
        }
        return new CompountORCondition(conditions);
    }
}

