/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.resource;

import com.google.common.base.Preconditions;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.ResourceValue;
import java.util.ArrayList;
import java.util.List;

public class ResourceResult
implements EvaluationResult {
    private String groupId;
    private ResourceValue resource;
    private List<ResourceValue> additionalResources;

    public ResourceResult(ResourceValue resource, List<ResourceValue> additionalResources) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"resources cannot be null.");
        Preconditions.checkArgument((additionalResources != null ? 1 : 0) != 0, (Object)"additionalResources cannot be null.");
        this.resource = resource;
        this.additionalResources = new ArrayList<ResourceValue>(additionalResources);
    }

    public ResourceResult(ResourceValue resource, List<ResourceValue> additionalResources, String groupId) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"resources cannot be null.");
        Preconditions.checkArgument((additionalResources != null ? 1 : 0) != 0, (Object)"additionalResources cannot be null.");
        this.resource = resource;
        this.additionalResources = new ArrayList<ResourceValue>(additionalResources);
        this.groupId = groupId;
    }

    @Override
    public List<ResourceValue> getAdditionalResources() {
        return new ArrayList<ResourceValue>(this.additionalResources);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public ResourceValue getValue() {
        return this.resource;
    }

    @Override
    public String getIdentifier() {
        return null;
    }

    @Override
    public Class<?> getValueType() {
        return ResourceValue.class;
    }

    @Override
    public boolean isEmpty() {
        return this.resource == null || this.resource.isEmpty();
    }
}

