/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.core.terminology;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.linuxforhealth.core.ObjectMapperUtil;
import io.github.linuxforhealth.core.config.ConverterConfiguration;
import io.github.linuxforhealth.core.terminology.CodingSystem;
import io.github.linuxforhealth.hl7.resource.ResourceReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SystemUrlLookup {
    private final Map<String, CodingSystem> systemUrls = SystemUrlLookup.loadFromFile();
    private static SystemUrlLookup systemURLLookupInstance;

    private SystemUrlLookup() {
        this.systemUrls.putAll(SystemUrlLookup.loadAdditionalFromFile());
    }

    private static Map<String, CodingSystem> loadFromFile() {
        TypeReference<List<CodingSystem>> typeRef = new TypeReference<List<CodingSystem>>(){};
        try {
            String content = ResourceReader.getInstance().getResourceInHl7Folder("codesystem/CodingSystemMapping.yml");
            List systems = (List)ObjectMapperUtil.getYAMLInstance().readValue(content, (TypeReference)typeRef);
            return systems.stream().collect(Collectors.toMap(CodingSystem::getId, codeSystem -> codeSystem));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read codesystem/CodingSystemMapping.yml", e);
        }
    }

    private static Map<String, CodingSystem> loadAdditionalFromFile() {
        TypeReference<List<CodingSystem>> typeRef = new TypeReference<List<CodingSystem>>(){};
        String filePath = ConverterConfiguration.getInstance().getAdditionalConceptmapFile();
        if (StringUtils.isNotBlank((CharSequence)filePath)) {
            try {
                FileInputStream fis = new FileInputStream(filePath);
                List systems = (List)ObjectMapperUtil.getYAMLInstance().readValue((InputStream)fis, (TypeReference)typeRef);
                return systems.stream().collect(Collectors.toMap(CodingSystem::getId, codeSystem -> codeSystem));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(filePath, e);
            }
        }
        return new HashMap<String, CodingSystem>();
    }

    public static String getSystemUrl(String value) {
        CodingSystem system;
        if (systemURLLookupInstance == null) {
            systemURLLookupInstance = new SystemUrlLookup();
        }
        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"http://") || StringUtils.startsWith((CharSequence)value, (CharSequence)"https://")) {
            return value;
        }
        if (value != null && (system = SystemUrlLookup.systemURLLookupInstance.systemUrls.get(StringUtils.upperCase((String)value))) != null) {
            return system.getUrl();
        }
        return null;
    }

    public static void init() {
        if (systemURLLookupInstance == null) {
            systemURLLookupInstance = new SystemUrlLookup();
        }
    }

    public static void reinit() {
        systemURLLookupInstance = new SystemUrlLookup();
    }
}

