/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.data;

import io.github.linuxforhealth.hl7.data.Hl7DataHandlerUtil;
import io.github.linuxforhealth.hl7.data.date.DateUtil;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.UnsupportedTemporalTypeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;
import org.hl7.fhir.r4.model.codesystems.EncounterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7RelatedGeneralUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hl7RelatedGeneralUtils.class);

    private Hl7RelatedGeneralUtils() {
    }

    public static String extractLow(Object var) {
        StringTokenizer stk;
        String val = Hl7DataHandlerUtil.getStringValue(var);
        if (StringUtils.isNotBlank((CharSequence)val) && (stk = new StringTokenizer(val, "-")).hasNext()) {
            return stk.next();
        }
        return null;
    }

    public static String extractHigh(Object var) {
        String[] values;
        String val = Hl7DataHandlerUtil.getStringValue(var);
        if (StringUtils.isNotBlank((CharSequence)val) && (values = val.split("-")).length == 2) {
            return values[1];
        }
        return null;
    }

    public static String getEncounterStatus(Object var1, Object var2, Object var3) {
        LOGGER.info("Generating encounter status from var1{}, var2 {}, var3 {}", new Object[]{var1, var2, var3});
        EncounterStatus status = EncounterStatus.UNKNOWN;
        if (var1 != null) {
            status = EncounterStatus.FINISHED;
        } else if (var2 != null) {
            status = EncounterStatus.ARRIVED;
        } else if (var3 != null) {
            status = EncounterStatus.CANCELLED;
        }
        return status.toCode();
    }

    public static String generateName(Object prefix, Object given, Object family, Object suffix) {
        String name;
        LOGGER.info("Generating name from  from prefix {}, given {}, family {} ,suffix {}", new Object[]{prefix, given, family, suffix});
        StringBuilder sb = new StringBuilder();
        String valprefix = Hl7DataHandlerUtil.getStringValue(prefix);
        String valgiven = Hl7DataHandlerUtil.getStringValue(given);
        String valfamily = Hl7DataHandlerUtil.getStringValue(family);
        String valsuffix = Hl7DataHandlerUtil.getStringValue(suffix);
        if (valprefix != null) {
            sb.append(valprefix).append(" ");
        }
        if (valgiven != null) {
            sb.append(valgiven).append(" ");
        }
        if (valfamily != null) {
            sb.append(valfamily).append(" ");
        }
        if (valsuffix != null) {
            sb.append(valsuffix).append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)(name = sb.toString()))) {
            return name.trim();
        }
        return null;
    }

    public static Long diffDateMin(Object start, Object end) {
        LOGGER.info("Generating time diff in min  from var1 {}, var2 {}", start, end);
        try {
            Temporal date1 = DateUtil.getTemporal(Hl7DataHandlerUtil.getStringValue(start));
            Temporal date2 = DateUtil.getTemporal(Hl7DataHandlerUtil.getStringValue(end));
            LOGGER.info("temporal dates start: {} , end: {} ", (Object)date1, (Object)date2);
            if (date1 != null && date2 != null) {
                return ChronoUnit.MINUTES.between(date1, date2);
            }
        }
        catch (UnsupportedTemporalTypeException e) {
            LOGGER.warn("Cannot evaluate time difference for start: {} , end: {} reason {} ", new Object[]{start, end, e.getMessage()});
            LOGGER.debug("Cannot evaluate time difference for start: {} , end: {} ", new Object[]{start, end, e});
            return null;
        }
        return null;
    }

    public static String split(Object input, String delimitter, int index) {
        StringTokenizer stk;
        String stringRepVal = Hl7DataHandlerUtil.getStringValue(input);
        if (StringUtils.isNotBlank((CharSequence)stringRepVal) && (stk = new StringTokenizer(stringRepVal, delimitter)).getTokenList().size() > index) {
            return (String)stk.getTokenList().get(index);
        }
        return null;
    }

    public static String concatenateWithChar(Object input, String delimiterChar) {
        String result = Hl7DataHandlerUtil.getStringValue(input, true, delimiterChar);
        return result;
    }
}

