/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.Expression;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.api.Specification;
import io.github.linuxforhealth.api.Variable;
import io.github.linuxforhealth.core.data.DataTypeUtil;
import io.github.linuxforhealth.core.exception.DataExtractionException;
import io.github.linuxforhealth.core.exception.RequiredConstraintFailureException;
import io.github.linuxforhealth.core.expression.EmptyEvaluationResult;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.core.expression.VariableUtils;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import io.github.linuxforhealth.hl7.expression.specification.SpecificationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractExpression
implements Expression {
    private static final String RESOURCE = "Resource";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExpression.class);
    private ExpressionAttributes attr;
    private String originalContext;
    private boolean conditionSatisfiedState;

    public AbstractExpression(ExpressionAttributes attr) {
        this.attr = attr;
    }

    @Override
    public String getType() {
        return this.attr.getType();
    }

    public ExpressionAttributes getExpressionAttr() {
        return this.attr;
    }

    @Override
    public EvaluationResult getDefaultValue() {
        return EvaluationResultFactory.getEvaluationResult(this.attr.getDefaultValue());
    }

    public boolean isRequired() {
        return this.attr.isRequired();
    }

    @Override
    public List<Specification> getspecs() {
        return this.attr.getSpecs();
    }

    @Override
    public List<Variable> getVariables() {
        return this.attr.getVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluationResult evaluate(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult baseValue) {
        Preconditions.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"dataSource cannot be null");
        Preconditions.checkArgument((contextValues != null ? 1 : 0) != 0, (Object)"contextValues cannot be null");
        Preconditions.checkArgument((baseValue != null ? 1 : 0) != 0, (Object)"baseValue cannot be null");
        try {
            this.setLoggingContext();
            LOGGER.info("Started Evaluating  with baseValue {} expression {} ", (Object)baseValue, (Object)this);
            HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>((Map<String, EvaluationResult>)ImmutableMap.copyOf(contextValues));
            if (!baseValue.isEmpty()) {
                localContextValues.put(baseValue.getIdentifier(), baseValue);
            }
            EvaluationResult result = this.evaluateValueOfExpression(dataSource, localContextValues, baseValue);
            LOGGER.info("Completed Evaluating returned value  {} ----  for  expression {} ", (Object)result, (Object)this);
            if (this.conditionSatisfiedState && this.isRequired() && (result == null || result.isEmpty())) {
                String stringRep = this.toString();
                throw new RequiredConstraintFailureException("Resource Constraint condition not satisfied for expression   :" + stringRep);
            }
            EvaluationResult evaluationResult = result;
            return evaluationResult;
        }
        catch (DataExtractionException | IllegalArgumentException e) {
            LOGGER.warn("Failure encountered during evaluation of expression {} , exception {}", (Object)this, (Object)this.attr.getName());
            EvaluationResult evaluationResult = null;
            return evaluationResult;
        }
        finally {
            this.resetLoggingContext();
        }
    }

    private void setLoggingContext() {
        this.originalContext = MDC.get((String)RESOURCE);
        MDC.put((String)RESOURCE, (String)(this.originalContext + "-> Field:" + this.getExpressionAttr().getName()));
    }

    private void resetLoggingContext() {
        MDC.put((String)RESOURCE, (String)this.originalContext);
    }

    private EvaluationResult evaluateValueOfExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult baseinputValue) {
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
        this.attr.getConstants().entrySet().forEach(e -> localContextValues.put((String)e.getKey(), EvaluationResultFactory.getEvaluationResult(e.getValue())));
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<ResourceValue> additionalresourcesresult = new ArrayList<ResourceValue>();
        List<Object> baseSpecvalues = AbstractExpression.getSpecValues(dataSource, localContextValues, baseinputValue, this.getspecs());
        LOGGER.debug("Base values evaluated {} -----  values {} ", (Object)this, baseSpecvalues);
        if (!baseSpecvalues.isEmpty()) {
            for (Object o : baseSpecvalues) {
                EvaluationResult gen = this.generateValue(dataSource, localContextValues, EvaluationResultFactory.getEvaluationResult(o));
                if (gen != null && gen.getValue() != null && !gen.isEmpty()) {
                    if (gen.getValue() instanceof List) {
                        result.addAll((Collection)gen.getValue());
                    } else {
                        result.add(gen.getValue());
                    }
                    additionalresourcesresult.addAll(gen.getAdditionalResources());
                }
                if (this.attr.isGenerateMultiple() || result.isEmpty()) continue;
                break;
            }
        } else {
            EvaluationResult gen = this.generateValue(dataSource, localContextValues, baseinputValue);
            if (gen != null && gen.getValue() != null && !gen.isEmpty()) {
                if (gen.getValue() instanceof List) {
                    result.addAll((Collection)gen.getValue());
                } else {
                    result.add(gen.getValue());
                }
                additionalresourcesresult.addAll(gen.getAdditionalResources());
            }
        }
        return this.getResult(result, additionalresourcesresult);
    }

    private EvaluationResult getResult(List<Object> result, List<ResourceValue> additionalresourcesresult) {
        if (!result.isEmpty() && !this.attr.isGenerateMultiple()) {
            return EvaluationResultFactory.getEvaluationResult(result.get(0), additionalresourcesresult);
        }
        if (!result.isEmpty()) {
            return EvaluationResultFactory.getEvaluationResult(result, additionalresourcesresult);
        }
        if (!this.getDefaultValue().isEmpty()) {
            return this.getDefaultValue();
        }
        return null;
    }

    protected static List<Object> getSpecValues(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult baseinputValue, List<Specification> specs) {
        ArrayList<Object> baseHl7Specvalues = new ArrayList<Object>();
        EvaluationResult specValues = specs == null || specs.isEmpty() ? baseinputValue : SpecificationUtil.extractMultipleValuesForSpec(specs, dataSource, (Map<String, EvaluationResult>)ImmutableMap.copyOf(contextValues));
        if (specValues != null && specValues.getValue() instanceof List) {
            baseHl7Specvalues.addAll((List)specValues.getValue());
        } else if (specValues != null) {
            baseHl7Specvalues.add(specValues.getValue());
        }
        return baseHl7Specvalues;
    }

    private EvaluationResult generateValue(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult baseValue) {
        HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
        if (baseValue != null && baseValue.getValue() != null) {
            localContextValues.put(DataTypeUtil.getDataType(baseValue.getValue()), baseValue);
        }
        localContextValues.putAll(AbstractExpression.resolveVariables(this.getVariables(), (Map<String, EvaluationResult>)ImmutableMap.copyOf(localContextValues), dataSource));
        if (this.isConditionSatisfied(localContextValues)) {
            this.conditionSatisfiedState = true;
            return this.evaluateExpression(dataSource, (Map<String, EvaluationResult>)ImmutableMap.copyOf(localContextValues), baseValue);
        }
        return null;
    }

    private static Map<String, EvaluationResult> resolveVariables(List<Variable> variables, Map<String, EvaluationResult> contextValues, InputDataExtractor dataSource) {
        HashMap<String, EvaluationResult> localVariables = new HashMap<String, EvaluationResult>();
        for (Variable var : variables) {
            try {
                EvaluationResult value = var.extractVariableValue((Map<String, EvaluationResult>)ImmutableMap.copyOf(contextValues), dataSource);
                if (value != null) {
                    localVariables.put(VariableUtils.getVarName(var.getVariableName()), EvaluationResultFactory.getEvaluationResult(value.getValue()));
                    continue;
                }
                localVariables.put(VariableUtils.getVarName(var.getVariableName()), new EmptyEvaluationResult());
            }
            catch (DataExtractionException e) {
                LOGGER.error("Cannot extract value for variable {} ", (Object)var.getVariableName(), (Object)e);
            }
        }
        return localVariables;
    }

    protected abstract EvaluationResult evaluateExpression(InputDataExtractor var1, Map<String, EvaluationResult> var2, EvaluationResult var3);

    @Override
    public boolean isConditionSatisfied(Map<String, EvaluationResult> contextValues) {
        if (this.attr.getFilter() != null) {
            return this.attr.getFilter().test(contextValues);
        }
        return true;
    }

    @Override
    public Map<String, String> getConstants() {
        return this.attr.getConstants();
    }

    protected static String getGroupId(Map<String, EvaluationResult> localContext) {
        EvaluationResult result = localContext.get("GROUP_ID");
        if (result != null) {
            return (String)result.getValue();
        }
        return null;
    }

    public String toString() {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.SIMPLE_STYLE);
        return new ToStringBuilder((Object)this).append("Expression Attributes", (Object)this.attr).build();
    }
}

