/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.linuxforhealth.api.Condition;
import io.github.linuxforhealth.api.Specification;
import io.github.linuxforhealth.api.Variable;
import io.github.linuxforhealth.core.expression.VariableUtils;
import io.github.linuxforhealth.core.expression.condition.ConditionUtil;
import io.github.linuxforhealth.hl7.expression.ExpressionType;
import io.github.linuxforhealth.hl7.expression.specification.SpecificationParser;
import io.github.linuxforhealth.hl7.expression.variable.VariableGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcherFactory;

@JsonDeserialize(builder=Builder.class)
public class ExpressionAttributes {
    private static final String OBJECT_TYPE = Object.class.getSimpleName();
    private String name;
    private String type;
    private String defaultValue;
    private boolean isRequired;
    private List<Specification> specs;
    private List<Variable> variables;
    private Condition condition;
    private Map<String, String> constants;
    private String value;
    private String valueOf;
    private boolean useGroup;
    private ExpressionType expressionType;
    private String toString;
    private boolean generateMultiple;
    private ImmutablePair<String, String> fetch;

    private ExpressionAttributes(Builder exBuilder) {
        this.type = exBuilder.type == null ? OBJECT_TYPE : exBuilder.type;
        this.defaultValue = exBuilder.defaultValue;
        this.name = exBuilder.name;
        this.isRequired = exBuilder.isRequired;
        this.specs = ExpressionAttributes.getSpecList(exBuilder.rawSpecs, exBuilder.useGroup);
        if (StringUtils.isNotBlank((CharSequence)exBuilder.rawCondition)) {
            this.condition = ConditionUtil.createCondition(exBuilder.rawCondition);
        }
        this.constants = new HashMap<String, String>();
        if (exBuilder.constants != null && !exBuilder.constants.isEmpty()) {
            this.constants.putAll(exBuilder.constants);
        }
        this.variables = new ArrayList<Variable>();
        if (exBuilder.rawVariables != null) {
            for (Map.Entry e : exBuilder.rawVariables.entrySet()) {
                this.variables.add(VariableGenerator.parse((String)e.getKey(), (String)e.getValue()));
            }
        }
        this.value = exBuilder.value;
        this.valueOf = exBuilder.valueOf;
        this.generateMultiple = exBuilder.generateList;
        this.expressionType = exBuilder.expressionType;
        this.useGroup = exBuilder.useGroup;
        if (this.expressionType == null && CollectionUtils.isNotEmpty(this.specs)) {
            this.expressionType = ExpressionType.HL7SPEC;
        }
    }

    public boolean isUseGroup() {
        return this.useGroup;
    }

    public String getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public List<Specification> getSpecs() {
        return ImmutableList.copyOf(this.specs);
    }

    public List<Variable> getVariables() {
        return ImmutableList.copyOf(this.variables);
    }

    public Condition getFilter() {
        return this.condition;
    }

    public Map<String, String> getConstants() {
        return ImmutableMap.copyOf(this.constants);
    }

    public boolean isGenerateMultiple() {
        return this.generateMultiple;
    }

    public String getValue() {
        return this.value;
    }

    public ImmutablePair<String, String> getFetch() {
        return this.fetch;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public String getValueOf() {
        return this.valueOf;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static final ExpressionModifiers extractExpressionModifiers(String inputString) {
        boolean extractMultiple = false;
        boolean retainEmpty = false;
        String expression = inputString;
        if (StringUtils.endsWith((CharSequence)expression, (CharSequence)"*")) {
            expression = StringUtils.removeEnd((String)expression, (String)"*");
            extractMultiple = true;
        }
        if (StringUtils.endsWith((CharSequence)expression, (CharSequence)"&")) {
            expression = StringUtils.removeEnd((String)expression, (String)"&");
            retainEmpty = true;
        }
        if (StringUtils.endsWith((CharSequence)expression, (CharSequence)"*")) {
            expression = StringUtils.removeEnd((String)expression, (String)"*");
            extractMultiple = true;
        }
        expression = StringUtils.strip((String)expression);
        return new ExpressionModifiers(extractMultiple, retainEmpty, expression);
    }

    public static List<Specification> getSpecList(String inputString, boolean useGroup) {
        ExpressionModifiers exp = ExpressionAttributes.extractExpressionModifiers(inputString);
        ArrayList<Specification> specs = new ArrayList<Specification>();
        if (StringUtils.isNotBlank((CharSequence)exp.expression)) {
            StringTokenizer st = new StringTokenizer(exp.expression, "|").setIgnoreEmptyTokens(true).setTrimmerMatcher(StringMatcherFactory.INSTANCE.spaceMatcher());
            st.getTokenList().forEach(s -> specs.add(SpecificationParser.parse(s, exp.extractMultiple, useGroup, exp.retainEmpty)));
        }
        return specs;
    }

    private static ImmutablePair<String, String> getPair(String tok) {
        if (StringUtils.isNotBlank((CharSequence)tok)) {
            String[] token = tok.split(":");
            if (token.length == 2) {
                return new ImmutablePair((Object)VariableUtils.getVarName(token[0]), (Object)token[1]);
            }
            if (token.length == 1) {
                return new ImmutablePair((Object)"BASE_VALUE", (Object)token[0]);
            }
            throw new IllegalArgumentException("fetch token not in correct format, expected format $varName:key, input" + tok);
        }
        return null;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE, (boolean)false, (boolean)false, (boolean)true, null);
        }
        return this.toString;
    }

    public static class ExpressionModifiers {
        public boolean extractMultiple = false;
        public boolean retainEmpty = false;
        public String expression = "";

        ExpressionModifiers(boolean theExtractMultiple, boolean theRetainEmpty, String theExpression) {
            this.extractMultiple = theExtractMultiple;
            this.retainEmpty = theRetainEmpty;
            this.expression = theExpression;
        }
    }

    public static class Builder {
        private String name;
        private String type;
        private String defaultValue;
        private boolean isRequired;
        private String rawSpecs;
        private String rawCondition;
        private Map<String, String> rawVariables;
        private Map<String, String> constants;
        private boolean useGroup;
        private ExpressionType expressionType;
        private String valueOf;
        private String value;
        private boolean generateList;

        public Builder() {
        }

        public Builder(String singleValue) {
            this.value = singleValue;
            this.expressionType = ExpressionType.SIMPLE;
        }

        public boolean isUseGroup() {
            return this.useGroup;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withDefault(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withRequired(boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public Builder withSpecs(String rawSpecs) {
            this.rawSpecs = rawSpecs;
            return this;
        }

        public Builder withUseGroup(boolean useGroup) {
            this.useGroup = useGroup;
            return this;
        }

        public Builder withCondition(String rawCondition) {
            this.rawCondition = rawCondition;
            return this;
        }

        public Builder withVars(Map<String, String> rawVariables) {
            this.rawVariables = rawVariables;
            return this;
        }

        public Builder withConstants(Map<String, String> constants) {
            this.constants = constants;
            return this;
        }

        public Builder withValueOf(String valueOf) {
            this.valueOf = StringUtils.trim((String)valueOf);
            if (this.expressionType == null) {
                this.expressionType = ExpressionType.SIMPLE;
            }
            return this;
        }

        public Builder withExpressionType(String expressionType) {
            this.expressionType = (ExpressionType)EnumUtils.getEnumIgnoreCase(ExpressionType.class, (String)expressionType);
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            this.expressionType = ExpressionType.SIMPLE;
            return this;
        }

        public Builder withGenerateList(boolean generateList) {
            this.generateList = generateList;
            return this;
        }

        public ExpressionAttributes build() {
            return new ExpressionAttributes(this);
        }
    }
}

