/*
 * Decompiled with CFR 0.152.
 */
package io.github.linuxforhealth.hl7.expression;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.github.linuxforhealth.api.EvaluationResult;
import io.github.linuxforhealth.api.InputDataExtractor;
import io.github.linuxforhealth.api.ResourceValue;
import io.github.linuxforhealth.core.expression.EvaluationResultFactory;
import io.github.linuxforhealth.core.resource.ResourceResult;
import io.github.linuxforhealth.hl7.expression.AbstractExpression;
import io.github.linuxforhealth.hl7.expression.ExpressionAttributes;
import io.github.linuxforhealth.hl7.resource.HL7DataBasedResourceModel;
import io.github.linuxforhealth.hl7.resource.ResourceReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ReferenceExpression
extends AbstractExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceExpression.class);
    private HL7DataBasedResourceModel data;
    private HL7DataBasedResourceModel referenceModel = (HL7DataBasedResourceModel)ResourceReader.getInstance().generateResourceModel("datatype/Reference");
    private String reference;

    @JsonCreator
    public ReferenceExpression(ExpressionAttributes expAttr) {
        super(expAttr);
        this.reference = expAttr.getValueOf();
        this.data = (HL7DataBasedResourceModel)ResourceReader.getInstance().generateResourceModel(this.reference);
        Preconditions.checkState((this.data != null ? 1 : 0) != 0, (Object)"Resource reference model cannot be null");
    }

    @Override
    public EvaluationResult evaluateExpression(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult baseValue) {
        Preconditions.checkArgument((dataSource != null ? 1 : 0) != 0, (Object)"dataSource cannot be null");
        Preconditions.checkArgument((contextValues != null ? 1 : 0) != 0, (Object)"contextValues cannot be null");
        LOGGER.debug("Evaluating expression {}", (Object)this.reference);
        EvaluationResult resourceReferenceResult = null;
        ResourceResult primaryResourceResult = this.evaluateResource(dataSource, contextValues, baseValue);
        if (primaryResourceResult != null && primaryResourceResult.getValue() != null) {
            ArrayList<ResourceValue> additionalResources = new ArrayList<ResourceValue>();
            additionalResources.addAll(primaryResourceResult.getAdditionalResources());
            additionalResources.add(primaryResourceResult.getValue());
            EvaluationResult genBaseValue = EvaluationResultFactory.getEvaluationResult(primaryResourceResult.getValue().getResource());
            HashMap<String, EvaluationResult> localContextValues = new HashMap<String, EvaluationResult>(contextValues);
            ResourceResult result = this.referenceModel.evaluate(dataSource, (Map<String, EvaluationResult>)ImmutableMap.copyOf(localContextValues), genBaseValue);
            if (result != null && result.getValue() != null) {
                ResourceValue resolvedvalues = result.getValue();
                LOGGER.debug("Evaluated expression {}, returning {} ", (Object)this.reference, (Object)resolvedvalues);
                if (resolvedvalues != null) {
                    resourceReferenceResult = EvaluationResultFactory.getEvaluationResult(resolvedvalues.getResource(), additionalResources);
                }
            }
        }
        return resourceReferenceResult;
    }

    private ResourceResult evaluateResource(InputDataExtractor dataSource, Map<String, EvaluationResult> contextValues, EvaluationResult hl7SpecValue) {
        ResourceResult result = this.data.evaluate(dataSource, (Map<String, EvaluationResult>)ImmutableMap.copyOf(contextValues), hl7SpecValue);
        if (result != null && result.getValue() != null) {
            return result;
        }
        return null;
    }

    public String getReference() {
        return this.reference;
    }
}

